#pragma once
#include "mainviewbase.h"
#include "SortArray.h"

class CSettingView :
	public CMainViewBase
{
public:
	CSettingView(void);
	~CSettingView(void);
	DECLARE_MESSAGE_MAP()
	afx_msg void OnPaint();

protected:
	int					m_tracking;

	void DrawListItem(CDC *pDC,int index,int fover,int fill=1);
	void SetupScroll();
	int GetPointItem(CPoint pt);
	void DoCommand(int command);

	void DoServerSetting();
	void DoSSICGISetting();

	class CSettingItem
	{
	public:
		CSettingItem() {};
		CSettingItem(HICON icon,CString label,CString info)
		{
			m_icon = icon;
			m_label = label;
			m_info = info;
			m_selected = 0;
		};

		HICON	m_icon;
		CString	m_label;
		CString	m_info;
		int		m_selected;
	};

	CSortArray<CSettingItem,CSettingItem&>	m_settingItem;

public:
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
};
