// StringListCtrl.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "StringListCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStringListCtrl

CStringListCtrl::CStringListCtrl()
{
}

CStringListCtrl::~CStringListCtrl()
{
}


BEGIN_MESSAGE_MAP(CStringListCtrl, CListCtrl)
	//{{AFX_MSG_MAP(CStringListCtrl)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
	ON_WM_CREATE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStringListCtrl bZ[W nh

//!	ŏ̑I擾
int CStringListCtrl::GetFirstSelect()
{
	int	i,len = GetItemCount();
	for(i=0;i<len;i++)
	{
		if(GetItemState(i, LVIS_SELECTED)==LVIS_SELECTED)
			return(i);
	}

	return(-1);
}

//!	IĂACe擾
int CStringListCtrl::GetSelectedItemCount()
{
	int	i,len = GetItemCount(),count=0;
	for(i=0;i<len;i++)
	{
		if(GetItemState(i, LVIS_SELECTED)==LVIS_SELECTED)
			count++;
	}

	return(count);
}

//!	IĂ邩擾
int CStringListCtrl::IsSelected(int index)
{
	if(GetItemState(index, LVIS_SELECTED)==LVIS_SELECTED)
		return(1);

	return(0);
}

//!	Xg̍XV
void CStringListCtrl::UpdateList(int sort)
{
	SetExtendedStyle(LVS_EX_FULLROWSELECT);

	//	\[g
	if(sort)
		m_itemList.Sort();

	//	Sč폜
	DeleteAllItems();

	//	ݒ
	int	i,len = (int)m_itemList.GetSize();
	for(i=0;i<len;i++)
	{
		InsertItem(i,m_itemList[i].m_text,m_itemList[i].m_image);
		int	j,len2 = (int)m_itemList[i].m_subText.GetSize();
		for(j=0;j<len2;j++)
		{
			SetItemText(i,j+1,m_itemList[i].m_subText[j]);
		}
	}
}

//!	I𒆂̍ڂ폜
void CStringListCtrl::DeleteSelectedItem()
{
	//	ݒ
	int	i,len = (int)m_itemList.GetSize();

	for(i=len-1;i>=0;i--)
	{
		if(IsSelected(i))
			m_itemList.RemoveAt(i);
	}
	UpdateList();
}

//!	IĂ鍀ڂRs[
void CStringListCtrl::CopySelectedItem(CStringListCtrl &other,int del,int overWrite)
{
	int	i,len = other.GetItemCount();
	for(i=0;i<len;i++)
	{
		if(other.IsSelected(i))
			Add(other.m_itemList[i],overWrite);
	}

	if(del)
		other.DeleteSelectedItem();

	UpdateList();
}

//!	S폜
void CStringListCtrl::ClearAll()
{
	m_itemList.RemoveAll();
	UpdateList();
}

//!	ǉ
void CStringListCtrl::Add(CListItem add,int overWrite)
{
	if(overWrite)
	{
		for(int i=0;i<m_itemList.GetSize();i++)
		{
			if(add.m_text == m_itemList[i].m_text)
			{
				m_itemList[i] = add;
				return;
			}
		}
	}
	
	m_itemList.Add(add);
	
}

int CStringListCtrl::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CListCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;


	return 0;
}

int CStringListCtrl::GetSize()
{
	return((int)m_itemList.GetSize());
}

CStringListCtrl::CListItem & CStringListCtrl::operator[](int index)
{
	return(m_itemList[index]);
}

int CStringListCtrl::FindText(CString text)
{
	for(int i=0;i<m_itemList.GetSize();i++)
	{
		if(m_itemList[i].m_text == text)
			return(i);
	}
	return(-1);
}

//	ACeI
void CStringListCtrl::SelectItem(int index)
{
	SetItemState(index,LVIS_SELECTED,LVIS_SELECTED);
}
