#pragma once

//!	WTCY
#define	TYPED_BUFFER_DEFAULT_COUNT	65536

/*!
	^wobt@NX
	TCY͑SăJEgAoCgւ*sizeof(TYPE)Kv
*/
template<typename TYPE>
class CTypedBuffer
{
public:
	CTypedBuffer<TYPE>(int count = TYPED_BUFFER_DEFAULT_COUNT)
	{
		m_data = NULL;
		m_dataCount = 0;
		
		//	m
		Alloc(count);
	}

	virtual ~CTypedBuffer<TYPE>(void)
	{
		Free();
	}

	/////////////////////////////////////////////////////////////////////////////////
	//	EI
	/////////////////////////////////////////////////////////////////////////////////
	//!	m
	void Alloc(int count)
	{
		ASSERT(count > 0);
		Free();

		if(count != 0)
		{
			m_data = new TYPE[count];
			m_dataCount = count;
		}
	}

	//!	J
	void Free()
	{
		if(m_data)
			delete m_data;
		m_data = NULL;
		m_dataCount = 0;
	}

	/////////////////////////////////////////////////////////////////////////////////
	//	擾
	/////////////////////////////////////////////////////////////////////////////////
	//!	|C^擾
	operator TYPE*()
	{
		ASSERT(m_data != NULL);
		return m_data;
	};

	//!	|C^擾
	TYPE *GetPtr()
	{
		ASSERT(m_data != NULL);
		return m_data;
	};

	//!	|C^擾
	char *GetBytePtr()
	{
		ASSERT(m_data != NULL);
		return (char *)m_data;
	};

	//!	TCY擾
	int GetCount()
	{
		return m_dataCount;
	};

	//!	TCY擾
	int GetSizeByte()
	{
		return m_dataCount * sizeof(TYPE);
	};

protected:
	/////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////
	//!	f[^
	TYPE	*m_data;

	//!	TCY
	int		m_dataCount;
};
