// UserDialog.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "UserDialog.h"
#include "UserImportDialog.h"


// CUserDialog _CAO

IMPLEMENT_DYNAMIC(CUserDialog, CDialog)
CUserDialog::CUserDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CUserDialog::IDD, pParent)
	, m_user(_T(""))
	, m_passwd(_T(""))
	, m_comment(_T(""))
{
}

CUserDialog::~CUserDialog()
{
}

void CUserDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ENABLE, m_enable);
	DDX_Control(pDX, IDC_DISABLE, m_disable);
	DDX_Text(pDX, IDC_USER, m_user);
	DDX_Text(pDX, IDC_PASSED, m_passwd);
	DDX_Text(pDX, IDC_COMMENT, m_comment);
}


BEGIN_MESSAGE_MAP(CUserDialog, CDialog)
	ON_BN_CLICKED(IDC_RIGHT, OnBnClickedRight)
	ON_BN_CLICKED(IDC_LEFT, OnBnClickedLeft)
	ON_BN_CLICKED(IDC_ADD, OnBnClickedAdd)
	ON_BN_CLICKED(IDC_DEL, OnBnClickedDel)
	ON_BN_CLICKED(IDC_IMPORT, OnBnClickedImport)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
END_MESSAGE_MAP()


// CUserDialog bZ[W nh

void CUserDialog::OnBnClickedRight()
{
	m_disable.CopySelectedItem(m_enable,1,1);
	m_enable.UpdateList();
	m_disable.UpdateList();
}

void CUserDialog::OnBnClickedLeft()
{
	m_enable.CopySelectedItem(m_disable,1,1);
	m_enable.UpdateList();
	m_disable.UpdateList();
}

void CUserDialog::OnBnClickedAdd()
{
	UpdateData();
	if(m_user.IsEmpty())
	{
		MessageBox("[U[͂ĂB");
		return;
	}

	CStringListCtrl::CListItem	add;

	add.m_text = m_user;
	add.m_dataText.Add(m_passwd);
	add.m_subText.Add(m_comment);

	if(m_disable.FindText(m_user) == -1)
	{
		m_enable.Add(add);
		m_enable.UpdateList();
	}
	else
	{
		m_disable.Add(add);
		m_disable.UpdateList();
	}
}

void CUserDialog::OnBnClickedDel()
{
	m_enable.DeleteSelectedItem();
	m_disable.DeleteSelectedItem();
	m_enable.UpdateList();
	m_disable.UpdateList();
}

void CUserDialog::OnBnClickedImport()
{
	CUserImportDialog	import;
	if(import.DoModal()==IDOK)
	{
		for(int i=0;i<import.m_user.GetSize();i++)
		{
			CStringListCtrl::CListItem	add;

			add.m_text = import.m_user[i].m_text;
			add.m_dataText.Add(import.m_user[i].m_subText[0]);
			add.m_subText.Add(import.m_user[i].m_subText[1]);

			if(m_disable.FindText(m_user) == -1)
			{
				m_enable.Add(add);
				m_enable.UpdateList();
			}
			else
			{
				m_disable.Add(add);
				m_disable.UpdateList();
			}
		}
	}
}

void CUserDialog::OnBnClickedOk()
{

	//	[U[̏o
	GET_APP()->m_setting.DeleteNode("User::Enable");
	CWorkspaceAccess enableUsers = GET_APP()->m_setting.GetAccess("User::Enable");
	int	i,len = (int)m_enable.GetSize();
	for(i=0;i<len;i++)
	{
		CWorkspaceAccess	adduser = enableUsers.GetAccess(m_enable[i].m_text);
		adduser.SetConfig("User",m_enable[i].m_text);
		adduser.SetConfig("Passwd",m_enable[i].m_dataText[0]);
		adduser.SetConfig("Comment",m_enable[i].m_subText[0]);
	}

	//	s[U[̏o
	GET_APP()->m_setting.DeleteNode("User::Disable");
	CWorkspaceAccess disableUsers = GET_APP()->m_setting.GetAccess("User::Disable");
	len = (int)m_disable.GetSize();
	for(i=0;i<len;i++)
	{
		CWorkspaceAccess	adduser = disableUsers.GetAccess(m_disable[i].m_text);
		adduser.SetConfig("User",m_disable[i].m_text);
		adduser.SetConfig("Passwd",m_disable[i].m_dataText[0]);
		adduser.SetConfig("Comment",m_disable[i].m_subText[0]);
	}

	GET_APP()->SaveSetting();
	OnOK();
}

BOOL CUserDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	//	C[WXg̏
	m_imageList.Create(16,16,ILC_COLOR8|ILC_MASK,1,1);
	m_imageList.SetBkColor(::GetSysColor(COLOR_WINDOW));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_USER2));

	CRect	r;
	m_enable.GetClientRect(r);
	m_enable.SetImageList(&m_imageList,LVSIL_SMALL);
	m_enable.InsertColumn(0,_T("[U["),LVCFMT_LEFT,100);
	m_enable.InsertColumn(1,_T("Rg"),LVCFMT_LEFT,r.Width() - 100);
	m_enable.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	m_disable.GetClientRect(r);
	m_disable.SetImageList(&m_imageList,LVSIL_SMALL);
	m_disable.InsertColumn(0,_T("[U["),LVCFMT_LEFT,100);
	m_disable.InsertColumn(1,_T("Rg"),LVCFMT_LEFT,r.Width() - 100);
	m_disable.SetExtendedStyle(LVS_EX_FULLROWSELECT);


	//	[U[̓ǂݍ
	{
		CWorkspaceAccess enableUsers = GET_APP()->m_setting.GetAccess("User::Enable");
		CStringArray	list;
		enableUsers.GetAllSubNode(list);
		for(int i=0;i<list.GetSize();i++)
		{
			CWorkspaceAccess user = enableUsers.GetAccess(list[i]);
			CStringListCtrl::CListItem	add;

			add.m_text = user.GetConfig("User","");
			add.m_dataText.Add(user.GetConfig("Passwd",""));
			add.m_subText.Add(user.GetConfig("Comment",""));
			m_enable.Add(add);
		}
	}

	//	s[U[̓ǂݍ
	{
		CWorkspaceAccess enableUsers = GET_APP()->m_setting.GetAccess("User::Disable");
		CStringArray	list;
		enableUsers.GetAllSubNode(list);
		for(int i=0;i<list.GetSize();i++)
		{
			CWorkspaceAccess user = enableUsers.GetAccess(list[i]);
			CStringListCtrl::CListItem	add;

			add.m_text = user.GetConfig("User","");
			add.m_dataText.Add(user.GetConfig("Passwd",""));
			add.m_subText.Add(user.GetConfig("Comment",""));
			m_disable.Add(add);
		}
	}

	m_enable.UpdateList();
	m_disable.UpdateList();

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


