#include "StdAfx.h"
#include ".\workspace.h"
#include "WorkspaceXMLReader.h"
#include "WorkspaceXMLWriter.h"
#include "TextTools.h"

//	fobO⏕
#ifndef DEBUG_OUT
	#define	DEBUG_OUT	TRACE
#endif

//	W
#define	DEFAULT_CLASS_TYPE	"CConfig"

//	[hI[tOmF
#define	WRITE_FUNCTION_CHECK()	if(m_readOnly) { ASSERT(0); return; };


CWorkspace::CWorkspace(CString className)
{
	if(className.IsEmpty())
		m_className = DEFAULT_CLASS_TYPE;
	else
		m_className = className;

	//	[gݒ
	m_root.SetNodeName(m_className);

	//	ǂݍݐpł͂Ȃ
	m_readOnly = 0;
}

CWorkspace::~CWorkspace(void)
{
	//	u폜
	for(int i=0;i<m_autoSwap.GetSize();i++)
		m_autoSwap[i]->Delete();
	m_autoSwap.RemoveAll();
}


/*********************************************************
	ANZX\Ȋ֐
**********************************************************/
/*!
	ANZXNX擾
*/
CWorkspaceAccess CWorkspace::GetAccess(CString path)
{
	return CWorkspaceAccess(this,path);
}


/*!
	ANZXNX擾AgNA
*/
CWorkspaceAccess CWorkspace::GetCleanAccess(CString path)
{
	CWorkspaceAccess ret = CWorkspaceAccess(this,path);
	ret.Clear();
	return ret;
}


/////////////////////////////////////////////////////////////////////////////////////
//	o͂Ɋւ鏈
/////////////////////////////////////////////////////////////////////////////////////
/*!
	XMLt@C֏o
*/
int CWorkspace::SaveToXMLFile(CString filePath, CString savePath)
{
	SCOPE_LOCK();

	try
	{
		//	ۑm[h̎擾
		CString key;
		CWorkspaceNode * node = GetSubNode(savePath,key);

		//	ۑ
		CWorkspaceXMLWriter	writer;
		writer.SaveToFile(&m_root, filePath, m_className);
	}
	catch(CXMLTextParserException err)
	{
		DEBUG_OUT("XML LoadError : %s\n", err.m_error);
		return(-1);
	}
	return(0);
}

/*!
	XMLt@C胍[h
*/
int CWorkspace::LoadFromXMLFile(CString filePath)
{
	SCOPE_LOCK();

	try
	{
		//	NA
		m_root.Clear();

		//	ǂݍ
		CWorkspaceXMLReader	reader;
		reader.LoadFromFile(&m_root, filePath, m_className);
	}
	catch(CXMLTextParserException err)
	{
		DEBUG_OUT("XML LoadError : %s\n", err.m_error);
		return(-1);
	}
	return(0);
}


/*!
	XML֏o
*/
CStringA CWorkspace::ToXMLStringUTF8(CString savePath)
{
	SCOPE_LOCK();

	return(CTextTools::ANSIToUTF8Str(ToXMLString(savePath).GetBuffer(0)));
}

/*!
	XML񂩂琶
*/
int CWorkspace::FromXMLStringUTF8(CStringA xml)
{
	SCOPE_LOCK();

	return(FromXMLString(CTextTools::UTF8ToANSIStr(xml.GetBuffer(0))));
}

/*!
	XML֏o
*/
CStringA CWorkspace::ToXMLString(CString savePath)
{
	SCOPE_LOCK();

	try
	{
		//	ۑm[h̎擾
		CString key;
		CWorkspaceNode * node = GetSubNode(savePath,key);

		//	ۑ
		CWorkspaceXMLWriter	writer;
		return(writer.ToString(&m_root, m_className));
	}
	catch(CXMLTextParserException err)
	{
		TRACE("XML LoadError : %s\n", err.m_error);
		return("");
	}
}

/*!
	XML񂩂琶
*/
int CWorkspace::FromXMLString(CStringA xml)
{
	SCOPE_LOCK();


	try
	{
		//	NA
		m_root.Clear();

		//	ǂݍ
		CWorkspaceXMLReader	reader;
		reader.FromString(&m_root, xml, m_className);
	}
	catch(CXMLTextParserException err)
	{
		TRACE("XML LoadError : %s\n", err.m_error);
		return(-1);
	}
	return(0);
}

/*!
	[hI[
*/
void CWorkspace::SetReadOnly(int readOnly)
{
	SCOPE_LOCK();
	m_readOnly = readOnly;
}

/*!
	u(Âɒus)
*/
void CWorkspace::AddAutoSwap(IWorkspaceAutoSwapPtr autoSwap)
{
	SCOPE_LOCK();

	DelAutoSwap(autoSwap);
	m_autoSwap.Add(autoSwap);
};

/*!
	u
*/
void CWorkspace::DelAutoSwap(IWorkspaceAutoSwapPtr autoSwap)
{
	SCOPE_LOCK();

	for(int i=0;i<m_autoSwap.GetSize();i++)
	{
		if(m_autoSwap[i] == autoSwap)
		{
			m_autoSwap.RemoveAt(i);
			break;
		}
	}
};


/*********************************************************
	Ȃ
**********************************************************/
/*!
	Sf[^NA
*/
void CWorkspace::Clear(CString path)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	path = ToNodePath(path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	node->Clear();
}


/*!
	Rs[

	srCWorkspaceɕʂCWorkspaceNXw肷ƁAʂ̃NXփRs[ł
*/
void CWorkspace::Copy(CString destPath, CString srcPath, CWorkspace* srCWorkspace)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	destPath = ToNodePath(destPath);
	srcPath = ToNodePath(srcPath);

	if(srCWorkspace==NULL || srCWorkspace==this)
	{
		CString key;
		CWorkspaceNode * dNode = GetSubNode(destPath,key);
		_Copy(dNode,srcPath);
	}
	else
	{
		srCWorkspace->m_scopeLock.Lock();
		CString key;
		CWorkspaceNode * dNode = GetSubNode(destPath,key);
		srCWorkspace->_Copy(dNode,srcPath);
		srCWorkspace->m_scopeLock.Unlock();
	}

}



/*********************************************************
	KeyɊւ鏈
**********************************************************/
/*!
	f[^̐ݒ
*/
void CWorkspace::SetKeyData(CString path, CString data,int noCase)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	node->SetKeyData(key,data,noCase);
}


/*!
	f[^̎擾
*/
CString CWorkspace::GetKeyData(CString path, CString defaultData,int noCase)
{
	SCOPE_LOCK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	if(!m_autoSwap.IsEmpty())
	{
		CString	data = node->GetKeyData(key, defaultData, noCase);
		for(int i=0;i<m_autoSwap.GetCount();i++)
			data = m_autoSwap[i]->SwapString(key, data);
		return(data);
	}
	else
		return(node->GetKeyData(key, defaultData, noCase));
}


/*!
	L[݂̑mF
*/
int CWorkspace::KeyIsExist(CString path,int noCase)
{
	SCOPE_LOCK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return node->KeyIsExist(key, noCase);
}


/*!
	f[^̍폜
*/
void CWorkspace::DeleteKey(CString path,int noCase)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	node->DeleteKey(key, noCase);
}


/*!
	L[擾
*/
int CWorkspace::GetKeyCount(CString path)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	path = ToNodePath(path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->GetKeyCount());
}


/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspace::GetAllKey(CString path,CStringArray &list)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	path = ToNodePath(path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->GetAllKey(list));
}


/*!
	SẴL[Rs[
*/
void CWorkspace::CopyAllKeys(CString path,CKeyDataArray &keyData)
{
	SCOPE_LOCK();

	CString key;
	CWorkspaceNode * sNode = GetSubNode(path,key);

	sNode->CopyAllKeys(keyData);
}

/*!
	񒆂̃L[f[^ɒu擾
*/
CString CWorkspace::GetKeySwapString(CString path, CString str, CString noData, IWorkspaceAutoSwapPtr tempSwap)
{
	SCOPE_LOCK();

	if(tempSwap != NULL)
		AddAutoSwap(tempSwap);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);
	CString	data = node->GetKeySwapString(str,noData);

	if(tempSwap != NULL)
		DelAutoSwap(tempSwap);

	return(data);
}

/////////////////////////////////////////////////////////////////////////////////////
//	KeyɊւ鏈 - WorkspaceStringList
/////////////////////////////////////////////////////////////////////////////////////
/*!
	L[
*/
int CWorkspace::FindKeyData(CString path, CString sData, int noCase)
{
	SCOPE_LOCK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->FindKeyData(sData,noCase));
}

/*!
	L[
*/
int CWorkspace::FindKeyDataPath(CString path, CString fPath, int eqPath)
{
	SCOPE_LOCK();

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->FindKeyDataPath(fPath, eqPath));
}



/******************************************************
	Tum[hɊւ鏈
*******************************************************/
/*!
	m[h폜
*/
void CWorkspace::DeleteNode(CString path)
{
	SCOPE_LOCK();
	WRITE_FUNCTION_CHECK();

	//	pXm[hĂƉ肷
	path = ToNodePath(path);

	//	Ō::폜
	path = path.Mid(0,path.GetLength()-2);


	if(path.IsEmpty())
	{
		//	[g폜H
		m_root.Clear();
	}
	else
	{
		CString key;
		CWorkspaceNode * node = GetSubNode(path,key);
		node->DeleteNode(key);
	}
}


/*!
	Tum[h𓾂
*/
int CWorkspace::GetSubNodeCount(CString path)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	path = ToNodePath(path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->GetSubNodeCount());
}


/*!
	SẴTum[h𕶎ƂĎ擾
*/
int CWorkspace::GetAllSubNode(CString path,CStringArray &list)
{
	SCOPE_LOCK();

	//	pXm[hĂƉ肷
	path = ToNodePath(path);

	CString key;
	CWorkspaceNode * node = GetSubNode(path,key);

	return(node->GetAllSubNode(list));

}



/*********************************************************
	̑̏
**********************************************************/
/*!
 	m[hpXɕύX
 
 	@param path	pX
 	@return		pX
*/
CString CWorkspace::ToNodePath(CString path)
{
	if(path.GetLength() >= 2)
	{
		if(path.Right(2) != "::")
			path += "::";
	}
	else
		path += "::";

	return path;
}

/*!
	Tum[h̃|C^擾
*/
CWorkspaceNode *CWorkspace::GetSubNode(CString &path,CString &key)
{
	SCOPE_LOCK();

	CWorkspaceNode *node = m_root.GetSubNode(path,key);
	ASSERT(node != NULL);

	return(node);
}


/*!
	Rs[
*/
void CWorkspace::_Copy(CWorkspaceNode *dest, CString srcPath)
{
	SCOPE_LOCK();

	CString key;
	CWorkspaceNode * sNode = GetSubNode(srcPath,key);

	//	OȊORs[
	CString	name = dest->GetNodeName();
	*dest = *sNode;
	dest->SetNodeName(name);
}
