#include "StdAfx.h"
#include "AcceptedSocketQueue.h"

CAcceptedSocketQueue::CAcceptedSocketQueue(void)
{
	m_semaphore.Create(0, 100000);
	m_maxQueue = 100;
	m_enable = TRUE;
}

CAcceptedSocketQueue::~CAcceptedSocketQueue(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////
//	C^[tF[X
///////////////////////////////////////////////////////////////////
/*!
	I
*/
void CAcceptedSocketQueue::Stop()
{
	SCOPE_LOCK();

	//	폜
	while(m_queue.GetSize())
		m_queue.RemoveHead().Abort();
}

/*!
	L
*/
void CAcceptedSocketQueue::EnableQueue(int enable)
{
	SCOPE_LOCK();

	m_enable = enable;

	//	~
	if(!enable)
		Stop();
}


/*!
	ǉ
*/
int CAcceptedSocketQueue::AddNewConnection(CAcceptedSocket newConnection)
{
	SCOPE_LOCK();

	//	^ or 
	if(m_queue.GetSize() >= m_maxQueue || !m_enable)
		return(-1);

	//	ǉ
	m_queue.AddTail(newConnection);
	::ReleaseSemaphore(m_semaphore, 1, NULL);

	return(0);
}

/*!
	擾
*/
CAcceptedSocket CAcceptedSocketQueue::GetNewConnection()
{
	SCOPE_LOCK();

	if(m_queue.GetSize() <= 0)
		return(CAcceptedSocket());
	return(m_queue.RemoveHead());
}

/*!
	ő吔ݒ
*/
void CAcceptedSocketQueue::SetMaxQueue(int max)
{
	m_maxQueue = max;
}

/*!
	݂̕ێ擾
*/
int CAcceptedSocketQueue::GetCurrentQueueCount()
{
	SCOPE_LOCK();

	return(m_queue.GetSize());
}
