#include "StdAfx.h"
#include "ContextManager.h"
#include "DateUtility.h"

CContextManager::CContextManager(void)
{
	//	l
	m_idCounter = 0;
	m_contextLogCount = 0;

	//	Xbh̈擾
	m_context = m_contextRoot.GetAccess("Threads");

	//	Xbh̈̃O擾
	m_contextLog = m_contextRoot.GetAccess("ThreadLogs");
}

CContextManager::~CContextManager(void)
{
}


//////////////////////////////////////////////////////////////////////////////////////
//	C^tF[X
//////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
int CContextManager::Start(CWorkspaceAccess setting)
{
	m_contextLogCount = setting.GetKeyInt(_T("Log::MaxThreadLog"), 20);
	return(0);
}


/*!
	VKReLXg
*/
CWorkspaceAccess CContextManager::GetNewContext()
{
	//	ReLXg
	CString	name;
	name.Format(_T("Thread_%04x"), GetNewID());

	//	ReLXg
	CWorkspaceAccess	newContext = m_context.GetAccess(name);
	newContext.SetKeyStr(_T("ThreadName"), name);

	//	쐬ݒ
	GetDate(newContext.GetAccess("StartTime"));
	return(newContext);
}

/*!
	ReLXgp
*/
void CContextManager::DeleteContext(CWorkspaceAccess context)
{
	//	ReLXg擾
	CString	name = context.GetConfig("ThreadName", "");

	//	O͗LH
	if(m_contextLogCount > 0)
	{
		//	t̐ݒ
		CWorkspaceAccess	date = context.GetAccess(_T("EndTime"));
		GetDate(date);

		//	bN
		WORKSPACE_LOCK(m_contextLog);

		//	̈̃Rs[
		CWorkspaceAccess	log = m_contextLog.GetAccess(name);
		log.Copy(context);

		//	O̒
		if(m_contextLog.GetSubNodeCount() > m_contextLogCount)
		{
			CStringArray	nodes;
			m_contextLog.GetAllSubNode(nodes);
			m_contextLog.DeleteNode(nodes[0]);
		}
	}

	//	̍폜
	m_context.DeleteNode(name);
}


/*!
	t擾
*/
void CContextManager::GetDate(CWorkspaceAccess date, int detail)
{
	//	NA
	date.Clear();

	//	
	CTime	time = CTime::GetCurrentTime();
	date.SetConfig("Date", time.Format("%Y/%m/%d"));
	date.SetConfig("Time", time.Format("%H:%M:%S"));
	date.SetConfig("GMT", CDateUtility::GetGMTString(time));

	if(detail)
	{
		date.SetConfig("Year", time.Format("%Y"));
		date.SetConfig("Month", time.Format("%m"));
		date.SetConfig("Day", time.Format("%d"));
		date.SetConfig("DayOfWeek", time.Format("%w"));

		date.SetConfig("MonthString", time.Format("%b"));
		date.SetConfig("DayOfWeekString", time.Format("%a"));

		date.SetConfig("Hour", time.Format("%H"));
		date.SetConfig("Minute", time.Format("%M"));
		date.SetConfig("Second", time.Format("%S"));

	}
}

/*!
	Rs[擾
*/
void CContextManager::GetContextCopy(CWorkspaceAccess copyTo)
{
	copyTo.Copy(m_contextRoot.GetAccess(""));
}


/*!
	eLXgƂĎ擾
*/
CString CContextManager::GetContextByXMLString()
{
	return m_contextRoot.ToXMLString();
}


//////////////////////////////////////////////////////////////////////////////////////
//	c[֐
//////////////////////////////////////////////////////////////////////////////////////
/*!
	VKID
*/
int CContextManager::GetNewID()
{
	return m_idCounter.IncCounter();
}
