#pragma once

/*!
	oCif[^
*/
class IBinaryData
{
public:
	//!	TCYύX
	virtual void __stdcall ReSize(int size) = 0;

	//!	TCY擾
	virtual int __stdcall GetSize() = 0;

	//!	ێĂf[^|C^擾
	virtual char* __stdcall GetPtr() = 0;
};
//!	|C^^
typedef IBinaryData*	IBinaryDataPtr;


/*!
	oCif[^ۉNX

	char[]`̃oCif[^Ǘ
	TCYŒ
*/
class CBinaryData
{
public:
	//!	ݒ
	enum
	{
		//!	WgTCY
		DEFAULT_GROW_SIZE = 32768
	};

public:
	CBinaryData(int allocSize = 0);
	CBinaryData(CBinaryData &other);
	CBinaryData(IBinaryDataPtr other);
	virtual ~CBinaryData(void);

	////////////////////////////////////////////////////////////////////////////////////////
	//	C^tF[XȂ
	////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	IBinaryDataPtr GetCoreInterface() { return m_interface; };

	//!	C^[tF[Xݒ
	void SetCoreInterface(IBinaryDataPtr interfaceToSet) { m_interface = interfaceToSet; };

	////////////////////////////////////////////////////////////////////////////////////////
	//	m
	////////////////////////////////////////////////////////////////////////////////////////
	//!	̈TCYύX
	void ReSize(int size) { m_interface->ReSize(size); }

	//! TCY擾
	int GetSize() {	return m_interface->GetSize(); };

	//! ʂݒ
	void SetGrowSize(int size) { m_core.SetGrowSize(size); };

	//! 0TCYɃȂî߁j
	void SetNoFreeEmpty(int size) { m_core.SetNoFreeEmpty(size); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	폜
	////////////////////////////////////////////////////////////////////////////////////////
	//! 폜
	int Remove(int start, int size);

	//! ɂ
	void Empty() { ReSize(0); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	|C^ANZX
	////////////////////////////////////////////////////////////////////////////////////////
	//!	擪|C^擾
	char * GetPtr() { return m_interface->GetPtr(); };

	//! char* ɕϊ
	operator char*() { return GetPtr(); };

	//! unsigned char* ɕϊ
	operator unsigned char*()  { return (unsigned char *)GetPtr(); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	
	////////////////////////////////////////////////////////////////////////////////////////
	//!	㏑(KvȂ΁Aobt@ǉ)
	void OverwriteData(int startOffset, char *data, int len);

	//!	ǉ
	void Append(const char *data,int size);

	//!	ǉ
	void AppendWide(const wchar_t *data,int count)	{ Append((char *)data, count * sizeof(wchar_t)); }

	//!	ǉ
	void AppendLPCWSTR(LPCWSTR str)			{ AppendWide(str, wcslen(str)); };

	//!	ǉ
	void AppendLPCSTR(LPCSTR str)			{ Append(str, strlen(str)); };

	//!	ǉ(CString)
	void AppendString(CStringA &str)		{ AppendLPCSTR(str); };

	//!	ǉ(CString)
	void AppendString(CStringW &str)		{ AppendLPCWSTR(str); };

	//!	ǉ(CBinaryData)
	void AppendBinary(CBinaryData &data)	{ Append(data.GetPtr(), data.GetSize()); };

	//!	ǉ(char)
	void AppendByte(char val)				{ Append(&val, 1); };

	//!	ǉ(short)
	void AppendWord(short val)				{ Append((char *)&val, 2); };

	//!	ǉ(long)
	void AppendDoubleWord(long val)			{ Append((char *)&val, 4); };

	////////////////////////////////////////////////////////////////////////////////////////
	//	ϊ
	////////////////////////////////////////////////////////////////////////////////////////
	//!	CString(R[hϊ͍sȂ)
	CString GetString();

	////////////////////////////////////////////////////////////////////////////////////////
	//	T[`
	////////////////////////////////////////////////////////////////////////////////////////
	//!	̈̌
	int SerachMemBlock(const char *block, int blockLen);

	//!	̈̌
	int SerachString(const CString &str)	{ return SerachMemBlock((const char *)str.GetString(), str.GetLength() * sizeof(TCHAR)); }

	////////////////////////////////////////////////////////////////////////////////////////
	//	t@C
	////////////////////////////////////////////////////////////////////////////////////////
	//!	f[^ۑ
	int SaveToFile(CString path, int append = FALSE);

	//!	Sēǂݍ
	int LoadFromFile(CString path, int maxReadSize = -1, int fromHead = TRUE);

protected:
	class CBinaryDataCore : public IBinaryData
	{
	public:
		CBinaryDataCore();
		virtual ~CBinaryDataCore();

		//!	TCYύX
		virtual void __stdcall ReSize(int size);

		//!	TCY擾
		virtual int __stdcall GetSize();

		//!	ێĂf[^|C^擾
		virtual char* __stdcall GetPtr();

		////////////////////////////////////////////////////////////////////////////////////////
		//	
		////////////////////////////////////////////////////////////////////////////////////////
		//!	
		void InitInternal();

		//! ʂݒ
		void SetGrowSize(int size) { m_growSize = size; };

		//!	0TCYɃȂî߁j
		void SetNoFreeEmpty(int enable) { m_noFreeEmpty = enable; };

	protected:
		////////////////////////////////////////////////////////////////////////////////////////
		//	oϐ
		////////////////////////////////////////////////////////////////////////////////////////
		//!	obt@{
		char	*m_buffer;

		//! obt@TCY
		int		m_usingSize;

		//! mۍς݃obt@TCY
		int		m_bufferSize;

		//! TCY
		int		m_growSize;

		//!	0TCỸ
		int		m_noFreeEmpty;
	};

	////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	////////////////////////////////////////////////////////////////////////////////////////
	//!	obt@{
	CBinaryDataCore	m_core;

	//!	obt@ANZX
	IBinaryDataPtr	m_interface;
};



/*!
	oCif[^ۉNX
	
*/
////////////////////////////////////////////////////////////////////////////////////////
//	
////////////////////////////////////////////////////////////////////////////////////////
/*!
	W
*/
_inline CBinaryData::CBinaryData(int allocSize)
{
	SetCoreInterface(&m_core);
	ReSize(allocSize);
}

/*!
	Rs[
*/
_inline CBinaryData::CBinaryData(CBinaryData &other)
{
	SetCoreInterface(&m_core);
	ReSize(other.GetSize());

	memmove(GetPtr(), other.GetPtr(), other.GetSize());
}

/*!
	C^tF[Xݒ
*/
_inline CBinaryData::CBinaryData(IBinaryDataPtr other)
{
	SetCoreInterface(other);
}

/*!
	fXgN^
*/
_inline CBinaryData::~CBinaryData(void)
{
}


////////////////////////////////////////////////////////////////////////////////////////
//	폜
////////////////////////////////////////////////////////////////////////////////////////
/*!
	폜
*/
_inline int CBinaryData::Remove(int start, int size)
{
	if(start < 0 || size < 0 || start + size > GetSize())
		return(-1);

	memmove(GetPtr() + start,GetPtr() + size, GetSize() - (start + size));
	ReSize(GetSize() - size);
	return(0);
}

////////////////////////////////////////////////////////////////////////////////////////
//	
////////////////////////////////////////////////////////////////////////////////////////
/*!
	㏑(KvȂ΁Aobt@ǉ)
*/
_inline void CBinaryData::OverwriteData(int startOffset, char *data, int len)
{
	if(startOffset + len >= GetSize())
		ReSize(startOffset + len);

	memmove(GetPtr() + startOffset, data, len);
}

/*!
	ǉ
*/
_inline void CBinaryData::Append(const char *data,int size)
{
	int	oldSize = GetSize();
	ReSize(size + oldSize);

	memmove(GetPtr() + oldSize, data, size);
}


////////////////////////////////////////////////////////////////////////////////////////
//	ϊ
////////////////////////////////////////////////////////////////////////////////////////
/*!
	CString
*/
_inline CString CBinaryData::GetString()
{
	CString ret;
	ret.SetString((LPCTSTR)GetPtr(), GetSize() / sizeof(TCHAR));

	return(ret);
}


////////////////////////////////////////////////////////////////////////////////////////
//	T[`
////////////////////////////////////////////////////////////////////////////////////////
/*!
	̈̌
*/
_inline int CBinaryData::SerachMemBlock(const char *block, int blockLen)
{
	//	T܂łȂ
	if(blockLen <= 0 || GetSize() == 0 || blockLen > GetSize())
		return(-1);

	//	
	char	*start = GetPtr(), *find = GetPtr();
	int		left = GetSize();
	while(left >= blockLen)
	{
		//	ŏ̕T
		find = (char*)memchr(find, block[0], left - blockLen + 1);
		if(find == NULL)
			return(-1);

		//	rĂ݂
		if(memcmp(find, block, blockLen) == 0)
			return(find - GetPtr());

		//	
		find++;
		left = GetSize() - (find - start);
	}
	return(-1);
}


//////////////////////////////////////////////////////////////////////
// ۑ
//////////////////////////////////////////////////////////////////////
/*!
	t@C֕ۑ

	\param path		pX
*/
_inline int CBinaryData::SaveToFile(CString path, int append)
{
	FILE	*out;
	if(append)
	{
		if(_tfopen_s(&out, path, _T("ab+")) != 0)
			return(-1);
	}
	else
	{
		if(_tfopen_s(&out, path, _T("wb")) != 0)
			return(-1);
	}

	//	
	fwrite(GetPtr(), GetSize(), 1, out);
	fclose(out);
	return(0);
}

/*!
	t@Cǂݏo

	\param path		pX
*/
_inline int CBinaryData::LoadFromFile(CString path, int maxReadSize, int fromHead)
{
	FILE	*out;
	if(_tfopen_s(&out, path, _T("rb")) != 0)
		return(-1);
	
	//	TCY擾
	fseek(out,0,SEEK_END);
	long	len = ftell(out);
	fseek(out,0,SEEK_SET);

	//	ǂݍ݃TCY
	if(maxReadSize != -1 && len > maxReadSize)
	{
		//	ǂݍ݃TCY
		len = maxReadSize;

		//	납H
		if(!fromHead)
			fseek(out,len,SEEK_END);
	}

	//	ǂݍ
	ReSize(len);
	fread(GetPtr(), GetSize(), 1, out);
	fclose(out);
	return(0);
}


////////////////////////////////////////////////////////////////////////////////////////
//	CBinaryDataCore
////////////////////////////////////////////////////////////////////////////////////////
_inline CBinaryData::CBinaryDataCore::CBinaryDataCore()
{
	InitInternal();
}

_inline CBinaryData::CBinaryDataCore::~CBinaryDataCore()
{
	if(m_buffer)
		delete m_buffer;
	InitInternal();
}

/*!
	TCYύX
*/
_inline void CBinaryData::CBinaryDataCore::ReSize(int size)
{
	//	NA
	if(size == 0)
	{
		if(!m_noFreeEmpty)
		{
			if(m_buffer)
				delete m_buffer;
			m_buffer = NULL;
			m_bufferSize = 0;
		}

		m_usingSize = 0;
		return;
	}

	//	m
	if(m_buffer == NULL || size > m_bufferSize)
	{
		int allocSize = (size / m_growSize + 1) * m_growSize;
		char *temp = new char[allocSize];
		int	transSize = m_bufferSize;

		//	]
		if(m_buffer != NULL)
		{
			if(m_bufferSize > size)
				transSize = size;

			memmove(temp, m_buffer, transSize);
			delete m_buffer;
		}

		//	ݒ
		m_buffer = temp;
		m_bufferSize = allocSize;
	}
	m_usingSize = size;
}

/*!
	TCY擾
*/
_inline int CBinaryData::CBinaryDataCore::GetSize()
{
	return m_usingSize;
}

/*!
	ێĂf[^|C^擾
*/
_inline char *CBinaryData::CBinaryDataCore::GetPtr()
{
	return m_buffer;
}

/*!
	
*/
_inline void CBinaryData::CBinaryDataCore::InitInternal()
{
	m_buffer = NULL;
	m_bufferSize = 0;
	m_usingSize = 0;
	m_noFreeEmpty = 0;
	SetGrowSize(DEFAULT_GROW_SIZE);
}


