#include "StdAfx.h"
#include "PipeServer.h"

#define	IOCP_EXIT		0
#define	IOCP_PIPE_0		1000

CPipeServer::CPipeServer(void)
{
	m_keyCounter = IOCP_PIPE_0;
}

CPipeServer::~CPipeServer(void)
{
	EndThread();
}


//////////////////////////////////////////////////////////////////////////////////
//	JnE~
//////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
int CPipeServer::Start(CString pipeName, int maxConnect, CPipeCommandExecuteBase *executer)
{
	//	ICOCP|[g
	if(m_iocp.Create(1))
		return(-1);

	//!	|[g҂󂯊Jn
	if(m_pipeListener.Init(pipeName, maxConnect))
		return(-1);

	//	Rs[
	m_executer = executer;

	return(StartThread());
}

/*!
	~
*/
void CPipeServer::Stop()
{
	EndThread();
}

//////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
//////////////////////////////////////////////////////////////////////////////////
/*!
	XbhC
*/
void CPipeServer::ThreadMain()
{
	while(1)
	{
		//	pCv𐶐Aڑ҂Jn
		m_pipeListener.StartWaitPipe(m_iocp, m_keyCounter);

		//	ؒfpCvAM^CAEgpCvT
		CheckDisconnect();

		//	Cxg҂
		LPOVERLAPPED	ovrp;
		DWORD			transBytes;
		DWORD			completionKey;
		if(!GetQueuedCompletionStatus(m_iocp, &transBytes, &completionKey, &ovrp, 500))
		{
			//	{ɃG[H
			if(ovrp == NULL)
			{
				//	^CAEgH
				if(GetLastError() != WAIT_TIMEOUT)
				{
					//	ȊÕG[炵
					Sleep(500);
				}
				continue;
			}
		}


		//	I
		if(completionKey == IOCP_EXIT)
		{
			CloseAll();
			return;
		}
		
		//	pCvڑ
		if(completionKey == m_keyCounter)
		{
			NewConnect();
			continue;
		}

		//	pCv
		if(completionKey >= IOCP_PIPE_0)
		{
			PipeTask(completionKey);
			continue;
		}
	}
}

/*!
	f
*/
void CPipeServer::Break()
{
	//	I𓊂
	static OVERLAPPED	ovrp;
	INIT_OVERLAPPED(ovrp, NULL);
	::PostQueuedCompletionStatus(m_iocp, 0, IOCP_EXIT, &ovrp);

	CThreadSkeleton::Break();
}


//////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////
/*!
	I
*/
void CPipeServer::CloseAll()
{
	m_pipeListener.Close();

	//	S폜
	for(int i=0;i<m_commandPipes.GetCount();i++)
		delete m_commandPipes[i];
	m_commandPipes.RemoveAll();
}


/*!
	VKڑ
*/
void CPipeServer::NewConnect()
{
	//	pCv}l[W
	CCommandRecvPipe *pipe = new CCommandRecvPipe();
	pipe->Init(this, m_executer, m_pipeListener.GetNewPipe(), m_keyCounter);
	m_commandPipes.Add(pipe);
	TRACE("Command pipe : Connect\n");

	m_keyCounter++;
	if(m_keyCounter == 0)	//	I[o[t[
		m_keyCounter = IOCP_PIPE_0;
}

/*!
	pCvʐM^XN
*/
void CPipeServer::PipeTask(DWORD completeKey)
{
	CCommandRecvPipe *pipe = GetPipe(completeKey);
	if(pipe != NULL)
	{
		pipe->PipeTask();
	}
}

/*!
	Ă邩mF
*/
void CPipeServer::CheckDisconnect()
{
	for(int i=(int)m_commandPipes.GetCount()-1;i>=0;i--)
	{
		if(m_commandPipes[i]->CheckDisconnect())
		{
			delete m_commandPipes[i];
			m_commandPipes.RemoveAt(i);

			TRACE("Command Pipe : Discoonect\n");
		}
	}
}

/*!
	pCv擾
*/
CCommandRecvPipe *CPipeServer::GetPipe(DWORD completeKey)
{
	//	
	for(int i=0;i<m_commandPipes.GetCount();i++)
	{
		if(m_commandPipes[i]->GetCompleteKey() == completeKey)
			return(m_commandPipes[i]);
	}

	return(NULL);
}
