#include "StdAfx.h"
#include "server.h"
#include "04WebServer.h"
#include "connection.h"
#include "dateutility.h"
#include "intervaltimer.h"
#include "TimeOut.h"
#include "ServerStartException.h"

/*!
	T[o[sJn
*/
CServer::CServer(void)
	: m_settingRoot("04WebServer")
{
	DEBUG_SET_THREAD_CLASS_NAME("CServer");

	try
	{
		//	ݒ[h
		if(m_settingRoot.LoadFromXMLFile(GET_APP()->GetAppPath() + "04WebServer.xml"))
			throw CServerStartException("04WebServer.xml̃[hɎs܂");

		//	ݒ̈擾
		m_setting = m_settingRoot.GetAccess("Setting");

		//	T[o̈擾
		m_serverInfo = m_infoRoot.GetAccess("ServerInfo");

		//	T[o̐ݒ
		InitServerInfo();

		//	^CAEgԂ̐ݒ
		CTimeOutMgr::GetGlobalManager()->SetDefaultTimeOutTime(m_setting.GetConfig("Basic::TimeOut",300)*1000);

		//	ϐ
		m_statusHideTime = -1;
		m_overloadFlag = 0;

		//	ő哯ڑ擾
		m_maxConnect = m_setting.GetKeyInt("Basic::MaxConnect", 100);

		//	אݒ擾
		m_overloadKeepTimer.SetInterval(m_setting.GetKeyInt("Enhance::OverloadKeepTime", 30) * 1000);
		m_overloadThreshold = m_setting.GetKeyInt("Enhance::OverloadThresholdActiveConnection", 90) * m_maxConnect / 100;
		if(m_overloadThreshold < 0)
			m_overloadThreshold = 0;
		if(m_overloadThreshold > m_maxConnect)
			m_overloadThreshold = m_maxConnect;

		//	ReLXg
		m_contextMgr.Start(m_setting);

		//	MimeTypes̃[h
		m_mimeTypes.Load(m_setting);

		//	ш搧L
		m_bandWidthMgr.Load(m_setting);

		//	_CWFXgF؃}l[W
		m_authMgr.Start(m_setting);

		//	SSL
		InitSSL();

		//	O
		m_log.Init(this);

		//	҂󂯊Jn
		StartListen();

		//	XbhJn
		if(StartThread())
			throw CServerStartException(_T("Xbh̊JnɎs܂"));
	}
	catch(CServerStartException e)
	{
		//	OɋL^
		m_log.WriteSystemLog(_T("T[őNɎs܂: ") + e.m_info);

		//	x
		throw e;
	}	
	m_log.WriteSystemLog(_T("T[oN܂"));
}


CServer::~CServer(void)
{
	EndThread();
}


/*!
 	T[o̐ݒ
*/
void CServer::InitServerInfo(void)
{
	//	T[o[l[
	m_serverInfo.SetConfig("ServerName", SERVER_NAME);

	//	o[W
	m_serverInfo.SetConfig("ServerVersion", SERVER_VER);

	//	VOj`
	CString	sig = m_setting.GetConfig("Basic::ServerSignature", "%ServerName%/%ServerVersion%");
	sig = m_serverInfo.GetKeySwapString(sig);
	m_serverInfo.SetConfig("ServerSignature", sig);
	
	//	T[o[[g
	m_serverInfo.SetConfig("ServerRoot", GET_APP()->GetAppPath());

	//	Settingu
	m_settingRoot.AddAutoSwap(new CSettingSwap(m_serverInfo));
}

/*!
	SSL
*/
void CServer::InitSSL()
{
	//	SSL͗LH
	if(m_setting.GetKeyInt(_T("Basic::EnableSSL"), 0))
		m_sslContext.Start(m_setting);
}

/*!
 	҂󂯊Jn
*/
int CServer::StartListen(void)
{
	//	XiN
	m_listener.Start(m_setting);

	//	AhXo^
	CIPAddress localhost = CIPAddress::GetLocalhost();
	m_serverInfo.SetConfig("ServerAddress", (CString)localhost);
	m_serverInfo.SetConfig("ServerHostName", localhost.GetHostName());

	//	|[go^
	m_serverInfo.SetConfig("ServerPort", m_setting.GetConfig("Basic::Port", 80));

	return(0);
}

/*!
	Xbh{
*/
void CServer::ThreadMain()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain");

	//	XbhD
	::SetThreadPriority(::GetCurrentThread(), THREAD_PRIORITY_ABOVE_NORMAL);

	CIntervalTimer	timer(1000);
	while(!GetBreak())
	{
		try
		{		
			//	ڑ͍őɓBĂ邩H
			if(m_connections.GetSize() < m_maxConnect)
				WaitNextConnection(200);	//	VKڑ҂
			else
				Sleep(50);					//	܂ő҂

			//	ؒfڑj
			ClearCompletedConnections();

			//	I[o[[ȟo
			CheckServerLoad();

			//	̍XV͂Pb
			if(timer.IsTimeout())
				UpdateServerInfo();
		}
		catch(CMemoryException *e)
		{
			e->Delete();

			//	ŝ߁AT[oꎞ~
			m_listener.EnableListen(FALSE);
			WaitForSomeObjects(30000, GetBreakEvent());
			m_listener.EnableListen(TRUE);

			m_log.WriteSystemLog("SystemError : ŝ߁A̐ڑؒf܂");
			SetServerStatus("ŝ߁A̐ڑؒf܂B");
		}

	}

	//	󂯕t~
	m_listener.ShutdownListen();

	//	SXbh~
	KillAllConnection();

	//	O̍XV
	m_log.WriteSystemLog("T[o~܂");
	m_log.UpdateLog();
}


/*!
	̐ڑ҂
*/
void CServer::WaitNextConnection(int timeout)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::WaitNextConnection");

	//	ڑv́H
	CAcceptedSocket	newSocket;
	if(GetNextAccess(newSocket, timeout))
	{
		CConnection	*connect = NULL;
		try
		{
			connect = new CConnection(this, newSocket);
			m_connections.Add(connect);
		}
		catch(CConnectionException e)
		{
			//	G[H
			m_log.WriteSystemLog("SystemError : %s",e.GetErrorInfo());
			if(connect)
				delete connect;

			TRACE("SystemError : %s",e.GetErrorInfo());
		}
		catch(CMemoryException *e)
		{
			//	|
			if(connect)
				delete connect;
			newSocket.Abort();

			//	x
			throw e;
		}
	}
}

/*!
	̃ANZX擾
*/
int CServer::GetNextAccess(CAcceptedSocket &nextAccess, int waitTime)
{
	//	ڑ܂ő҂
	if(WaitForSomeObjects(waitTime, m_listener.GetIAcceptedSockeQueueAccess()->GetSemaphore()) == 1)
	{
		nextAccess = m_listener.GetIAcceptedSockeQueueAccess()->GetNewConnection();
		return(1);
	}
	return(0);
}


/*!
	ؒfڑj
*/
void CServer::ClearCompletedConnections()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::ClearCompletedConnections");

	//	Iڑ̍폜
	for(int i=(int)m_connections.GetSize()-1;i>=0;i--)
	{
		if(((CConnection *)m_connections[i])->IsRunning() == 0)
		{
			delete (CConnection *)m_connections[i];
			m_connections.RemoveAt(i);
		}
	}
}

/*!
	T[oג
*/
void CServer::CheckServerLoad()
{
	//	I[o[[ȟo
	if(m_connections.GetSize() >= m_overloadThreshold || m_listener.QueueIsOverload())
	{
		if(!m_overloadFlag.GetCounter())
			SetServerStatus("T[o͍׏ԂłB");
		m_overloadFlag = 1;

		//	莞ԕێ
		m_overloadKeepTimer.Reset();
	}
	else
	{
		//	ێԌo
		if(m_overloadKeepTimer.IsTimeout())
		{
			if(m_overloadFlag.GetCounter())
				SetServerStatus("T[o͈ꎞIɍ׏ԂɂȂ܂B");
			m_overloadFlag = 0;
		}
	}
}

/*!
	T[oXV
*/
void CServer::UpdateServerInfo()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::UpdateInfo");

	//	݂̐ڑ
	m_serverInfo.SetKeyInt("CurrentConnection", m_connections.GetSize());

	//	݂܂ł̐ڑ
	m_serverInfo.SetKeyInt("AllConnected", m_bandWidthMgr.GetAllCount());

	//	݂܂ł̓]
	m_serverInfo.SetKeyInt64("AllRecvSize", m_bandWidthMgr.GetAllRecv());
	m_serverInfo.SetKeyInt64("AllSendSize", m_bandWidthMgr.GetAllSend());

	//	ߋPԂ̐ڑ
	m_serverInfo.SetKeyInt("Connected1Hour", m_bandWidthMgr.GetCount1h());

	//	ߋPԂ̓]
	m_serverInfo.SetKeyInt64("RecvSize1Hour", m_bandWidthMgr.GetRecv1h());
	m_serverInfo.SetKeyInt64("SendSize1Hour", m_bandWidthMgr.GetSend1h());

	//	Xe[^XXVPH
	if(m_statusHideTime != -1 && m_statusHideTime < CTime::GetCurrentTime())
	{
		m_statusHideTime = -1;
		GET_APP()->SetServerStatus("T[o͐ɍ쓮łB");
	}

	//	O̍XV
	m_log.UpdateLog();
}

/*!
	I[o[[hԂ擾
*/
int CServer::ServerIsOverload()
{
	return(m_overloadFlag.GetCounter());
}



/*!
	SĂ̐ڑ̒~
*/
void CServer::KillAllConnection()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CServer::KillAllConnection");

	//	T[o[~tO
	m_serverInfo.SetConfig("StopServer",1);

	for(int i=(int)m_connections.GetSize()-1;i>=0;i--)
	{
		((CConnection *)m_connections[i])->Break();
	}

	for(int i=(int)m_connections.GetSize()-1;i>=0;i--)
	{
		delete (CConnection *)m_connections[i];
		m_connections.RemoveAt(i);
	}
}


/*!
	T[oXe[^X̐ݒ
*/
void CServer::SetServerStatus(CString status, CTimeSpan viewTime)
{
	GET_APP()->SetServerStatus(status);
	m_statusHideTime = CTime::GetCurrentTime() + viewTime;
}

/*!
	ڑ̎擾
*/
int CServer::GetConnectCount()
{
	return(m_serverInfo.GetConfig("CurrentConnection",0));
}



/*!
	Setting̒uR[obN
*/
CString CSettingSwap::SwapString(CString key,CString data)
{
	//	DATE?
	if(	data.Find("Date") != -1 || 
		data.Find("Time") != -1 || 
		data.Find("GMT") != -1 || 
		data.Find("Year") != -1 || 
		data.Find("Month") != -1 || 
		data.Find("Day") != -1 || 
		data.Find("DayOfWeek") != -1 || 
		data.Find("MonthString") != -1 || 
		data.Find("DayOfWeekString") != -1 || 
		data.Find("Hour") != -1 || 
		data.Find("Minute") != -1 || 
		data.Find("Second") != -1)
	{
		CWorkspace	m_date;
		CWorkspaceAccess date = m_date.GetAccess("Date");
		date.Clear();

		//	
		CTime	time=CTime::GetCurrentTime();
		date.SetConfig("Date",time.Format("%Y/%m/%d"));
		date.SetConfig("Time",time.Format("%H:%M:%S"));
		date.SetConfig("GMT",CDateUtility::GetGMTString(time));

		date.SetConfig("Year",time.Format("%Y"));
		date.SetConfig("Month",time.Format("%m"));
		date.SetConfig("Day",time.Format("%d"));
		date.SetConfig("DayOfWeek",time.Format("%w"));

		date.SetConfig("MonthString",time.Format("%b"));
		date.SetConfig("DayOfWeekString",time.Format("%a"));

		date.SetConfig("Hour",time.Format("%H"));
		date.SetConfig("Minute",time.Format("%M"));
		date.SetConfig("Second",time.Format("%S"));
		data = date.GetKeySwapString(data,"");
	}

	//	Infoɂuim_serverInfõR[obNm_settinggpցI@fbhbN̉\j
	data = m_serverInfo.GetKeySwapString(data,"");

	return(data);
}



