#include "StdAfx.h"
#include "threadskeleton.h"
#include "04WebServer.h"

CThreadSkeleton::CThreadSkeleton(void)
{
	m_thread = NULL;
	m_hThread = NULL;

	//	fpCxg
	m_breakEvent.Create(TRUE,FALSE);

	//	NXݒ
	DEBUG_SET_THREAD_CLASS_NAME("CThreadSkeleton");
}

CThreadSkeleton::~CThreadSkeleton(void)
{
	//	Xbh~
	EndThread();

	//	XbhIuWFNg폜
	SAFE_DELETE(m_thread);	//	Xbhnh͗l
}



////////////////////////////////////////////////////////////////////////////////////////////
//	JnEIEf
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh̊Jn
*/
int CThreadSkeleton::StartThread(int stackSize)
{
	//	fCxg
	::ResetEvent(m_breakEvent);

	//	Xbh쐬
	m_thread = AfxBeginThread(WorkThread, this, THREAD_PRIORITY_NORMAL, stackSize*1024, CREATE_SUSPENDED);
	if(m_thread == NULL)
	{
		TRACE("GetLastError :%d\n",GetLastError());
		return(-1);
	}

	//	폜
	m_thread->m_bAutoDelete = FALSE;

	//	nh擾
	m_hThread = m_thread->m_hThread;

	//	XbhsJn
	m_thread->ResumeThread();

	return(0);
}


/*!
	Xbh̏I
*/
void CThreadSkeleton::EndThread()
{
	Break();

	//	XbhI܂ő҂
	if(IsRunning())
		::WaitForSingleObject(m_hThread, INFINITE);
}


/*!
	f
*/
void CThreadSkeleton::Break()
{
	::SetEvent(m_breakEvent);
}

/*!
	IiʂȗRAgp֎~j
*/
void CThreadSkeleton::ForceKillThread()
{
	::TerminateThread(m_hThread, 0);
	::SetEvent(m_breakEvent);
}

/*!
	s擾
*/
int CThreadSkeleton::IsRunning()
{
	if(m_hThread == NULL)
		return(0);

	return(::WaitForSingleObject(m_hThread, 0) != WAIT_OBJECT_0);
};

/*!
	fw擾
*/
int CThreadSkeleton::GetBreak()
{
	return(WaitForSingleObject(m_breakEvent,0) == WAIT_OBJECT_0);
};



////////////////////////////////////////////////////////////////////////////////////////////
//	c[֐
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	̃IuWFNg҂

	\return	-1:G[A0:^CAEgA1ȍ~:nh	
*/
int CThreadSkeleton::WaitForSomeObjects(int timeoutMs, HANDLE obj1, HANDLE obj2, HANDLE obj3, HANDLE obj4)
{
	HANDLE	wait[4];
	DWORD 	count;

	wait[0] = obj1;
	wait[1] = obj2;
	wait[2] = obj3;
	wait[3] = obj4;

	//	nhJEg
	for(count=0;count<4;count++)
	{
		if(wait[count] == NULL)
			break;
	}

	DWORD ret = ::WaitForMultipleObjects(count,wait,FALSE,timeoutMs);
	if(ret == WAIT_TIMEOUT)
		return(0);

	if(ret >= WAIT_OBJECT_0 && ret < WAIT_OBJECT_0 + count)
		return(ret - WAIT_OBJECT_0 + 1);

	return(-1);
}

////////////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	pNXThreadMainĂ
*/
void CThreadSkeleton::_ThreadMain()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CThreadSkeleton::_ThreadMain");

#ifndef _DEBUG
	try
	{
#endif

		ThreadMain();

#ifndef _DEBUG
	}
	catch(CMemoryException *err)
	{
		GET_APP()->WriteDebugLog("sɂAXbh~܂B");
		err->Delete();

		//	NX
		TCHAR   szCause[255];
		sprintf_s(szCause, 254, "\tClass = %s, Function = %s", m_className, m_functionName);
		GET_APP()->WriteDebugLog(szCause);
	}
	catch(CException *err)
	{
		GET_APP()->WriteDebugLog("T[o̖MFCOɂAXbh~܂B");

		//	ڍ׃bZ[W
		TCHAR   szCause[255];
		err->GetErrorMessage(szCause, 255);
		GET_APP()->WriteDebugLog(szCause);

		//	NX
		sprintf_s(szCause, 254, "\tClass = %s, Function = %s", m_className, m_functionName);
		GET_APP()->WriteDebugLog(szCause);

		err->Delete();
	}
#endif

}


/*!
	s֐
*/
UINT CThreadSkeleton::WorkThread(LPVOID pParam)
{
	CoInitialize(NULL);

#ifndef _DEBUG
	//	Oۑp
	EXCEPTION_RECORD	savedExceptRec;

	__try
	{
#endif
		((CThreadSkeleton*)pParam)->_ThreadMain();
#ifndef _DEBUG
	}
	__except(savedExceptRec = *(GetExceptionInformation())->ExceptionRecord, EXCEPTION_EXECUTE_HANDLER)
	{
		GET_APP()->WriteDebugLog("T[o̖OɂAXbh~܂B");

		//	ڍ׃bZ[W
		TCHAR   szCause[255];
		sprintf_s(szCause, 254, "\tError code = 0x%x, Error address = 0x%p", savedExceptRec.ExceptionCode, savedExceptRec.ExceptionAddress);
		GET_APP()->WriteDebugLog(szCause);

		__try
		{
			//	NX
			sprintf_s(szCause, 254, "\tClass = %s, Function = %s", ((CThreadSkeleton*)pParam)->m_className, ((CThreadSkeleton*)pParam)->m_functionName);
			GET_APP()->WriteDebugLog(szCause);
		}
		__except(EXCEPTION_EXECUTE_HANDLER)
		{
			GET_APP()->WriteDebugLog("NXĵ߁Aڍ׏擾s\ł");
		}
	}
#endif
	CoUninitialize();

	return(0);
}
