#pragma once
#include "Workspace.h"

/*!
	Workspace List ̃\[gsx[XNX
*/
class CWorkspaceListAccessSortBase
{
public:
	virtual int IsBefore(CWorkspaceAccess from, CWorkspaceAccess to) = 0;
};

/*!
	Workspace List ̃\[gsNX
*/
class CWorkspaceListAccessSimpleSort : public CWorkspaceListAccessSortBase
{
public:
	virtual int IsBefore(CWorkspaceAccess from, CWorkspaceAccess to);

	CStringArray	m_keyName;
};

/*!
	Workspace List
*/
class CWorkspaceListAccess : public CWorkspaceAccess
{
public:
	CWorkspaceListAccess(CString listName);
	CWorkspaceListAccess(CWorkspaceAccess &other, CString listName);
	virtual ~CWorkspaceListAccess(void);

	//!	CWorkspaceAccess ݒ
	void operator = (CWorkspaceAccess &other) {	CWorkspaceAccess::operator=(other); }

	//////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////
	//!	̎擾
	int GetItemCount();

	//!	ACe̎擾
	CWorkspaceAccess GetItem(int index);

	//!	ACeǉ
	CWorkspaceAccess GetNewItem();

	//!	ACe̍폜
	void DeleteItem(CWorkspaceAccess item);

	//!	ACe̍폜
	void DeleteItem(int index);

	//////////////////////////////////////////////////////////////////////////////
	//	\[g
	//////////////////////////////////////////////////////////////////////////////
	//!	\[g
	void Sort(CWorkspaceListAccessSortBase *sortBase);

	//!	\[g(L[e)
	void Sort(CString key1, CString key2="", CString key3="");

protected:
	/////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////
	//!	O
	CString			m_listName;
};



/*!
	Workspace List
*/
template<class TYPE>
class CWorkspaceTypedListAccess : public CWorkspaceListAccess
{
public:
	CWorkspaceTypedListAccess(CString listName)
		: CWorkspaceListAccess(listName) {};
	CWorkspaceTypedListAccess(CWorkspaceAccess &other, CString listName)
		 : CWorkspaceListAccess(other, listName) {};

	//!	CWorkspaceAccess ݒ
	void operator = (CWorkspaceAccess &other) {	CWorkspaceListAccess::operator=(other); }

	//////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////
	//!	ACe̎擾
	TYPE GetItem(int index) { return CWorkspaceListAccess::GetItem(index); };

	//!	ACeǉ
	TYPE GetNewItem() { return CWorkspaceListAccess::GetNewItem(); };
};
