#include "StdAfx.h"
#include "OverlapedPipe.h"
#include "SyncObject.h"

#define	MAX_PACKET_SIZE		(1024 * 1024)

COverlapedPipe::COverlapedPipe(void)
{
	m_hPipe = NULL;
}

COverlapedPipe::~COverlapedPipe(void)
{
	Close();
}


//////////////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
int COverlapedPipe::Init(HANDLE pipe, ULONG_PTR CompletionKey)
{
	m_hPipe = pipe;
	m_completeKey = CompletionKey;

	return(0);
}

/*!
	I
*/
void COverlapedPipe::Close()
{
	SAFE_CLOSE_HANDLE(m_hPipe);
}


//////////////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	MJn
*/
int COverlapedPipe::StartWaitRecv()
{
	//	OVRP
	INIT_OVERLAPPED(m_ovrp, NULL);
	
	//	M
	m_recvData.ReSize(MAX_PACKET_SIZE);

	//	MJn
	if(!ReadFile(m_hPipe, m_recvData.GetPtr(), MAX_PACKET_SIZE, NULL, &m_ovrp))
	{
		//	̑̃G[H
		if(GetLastError() !=  ERROR_IO_PENDING)
		{
			TRACE("error COverlapedPipe::StartWaitRecv : 0x%x\n", GetLastError());
			return(-1);
		}
	}

	m_timer.Reset();
	return(0);
}



/*!
	MJn
*/
int COverlapedPipe::StartWaitSend()
{
	//	OVRP
	INIT_OVERLAPPED(m_ovrp, NULL);

	//	MJn
	if(!WriteFile(m_hPipe, m_sendData.GetPtr(), m_sendData.GetSize(), NULL, &m_ovrp))
	{
		//	̑̃G[H
		if(GetLastError() !=  ERROR_IO_PENDING)
		{
			TRACE("error COverlapedPipe::StartWaitSend : 0x%x\n", GetLastError());
			return(-1);
		}
	}

	m_timer.Reset();
	return(0);
}

/*!
	M
*/
int COverlapedPipe::EndOverlap()
{
	//	IH
	if(m_ovrp.Internal != ERROR_SUCCESS)
	{
		TRACE("error COverlapedPipe::EndOverlap : 0x%x\n", m_ovrp.Internal);
		return(-1);
	}

	//	TCY擾
	if(m_ovrp.InternalHigh > MAX_PACKET_SIZE)
		return(-1);
	
	//	TCYݒ
	m_recvData.ReSize((int)m_ovrp.InternalHigh);

	return(0);
}

