/*!
	XV

	2005/05/21 AUTH_USER, AUTH_PASSWORD, PHP_AUTH_USER, PHP_AUTH_PWɑΉ
*/

#include "StdAfx.h"
#include "subprocess.h"
#include "Dir.h"

#define	BUFFER_SIZE	65536

CSubProcess::CSubProcess(CServer *server,CConnectionInterrupt interrup)
: m_stdin(0), m_stdout(0), m_stderr(0), m_env(0),
  m_hReadPipe(NULL), m_hWritePipe(NULL), m_hInReadPipe(NULL),m_hInWritePipe(NULL),m_hInWriteWait(NULL),
  m_hErrReadPipe(NULL), m_hErrWritePipe(NULL),
  m_interrupt(interrup)
{
	m_server = server;
	m_prosessCreated = 0;
	m_breakFlag = 0;
	memset(&m_processInfo,0,sizeof(m_processInfo));
}

CSubProcess::~CSubProcess(void)
{
	TerminateProcess();

	::DisconnectNamedPipe(m_hInWritePipe);
	::CloseHandle(m_hReadPipe);
	::CloseHandle(m_hWritePipe);
	::CloseHandle(m_hInReadPipe);
	::CloseHandle(m_hInWritePipe);
	::CloseHandle(m_hInWriteWait);
	::CloseHandle(m_hErrReadPipe);
	::CloseHandle(m_hErrWritePipe);

	if(m_processInfo.hProcess)
		::CloseHandle(m_processInfo.hProcess);
	if(m_processInfo.hThread)
		::CloseHandle(m_processInfo.hThread);
}

//	CGIȂ΁ACGIR}h擾
CString CSubProcess::GetCGICommand(CServer *server,CString path,CString queryDecoded)
{
	//	t@CAgq̎擾
	CString	fileName = path;
	CString	ext = CDir::PathToExt(fileName);

	//	ݒ胊Xg擾
	CWorkspaceAccess	cgiSetting = server->m_setting.GetAccess("CGI");
	CStringArray	cgiList;
	cgiSetting.GetAllSubNode(cgiList);

	//	eݒ
	for(int i=0;i<cgiList.GetSize();i++)
	{
		CWorkspaceAccess	oneSetting = cgiSetting.GetAccess(cgiList[i]);

		//	gq͓H
		if(ext.CompareNoCase(oneSetting.GetConfig("FileExt","")) == 0)
		{
			//	t@Cwb_擾
			CString	header = GetFirstLine(fileName);

			if((oneSetting.GetConfig("ExecuteFile",0) == 1 && header.GetLength() >= 2 && header[0] == 'M' && header[1] == 'Z')						//	st@C
			|| (oneSetting.GetConfig("ExecuteFile",0) == 0 && (oneSetting.GetConfig("FileHeader","").IsEmpty() || header.MakeLower().Find(oneSetting.GetConfig("FileHeader","").MakeLower()) != -1)))		//	ȊO
			{
				//	R}h쐬
				CWorkspace			swap;
				CWorkspaceAccess	swapAccess = swap.GetAccess("Swap");
				
				//	Xy[Xꍇ́A""ǉ
				if(fileName.Find(" ") != -1)
					swapAccess.SetConfig("FilePath","\"" + fileName + "\"");
				else
					swapAccess.SetConfig("FilePath",fileName);
				swapAccess.SetConfig("Query",queryDecoded);

				CString command = oneSetting.GetConfig("Command","");
				command = swapAccess.GetKeySwapString(command);

				return(command);
			}
		}
	}

	return("");
}


//	vZXN
int CSubProcess::RunSubProcess(CString command,CString workPath,CString threadID)
{
	//	pCv
	if(CreatePipe(threadID))
		throw CSubProcessException("vZXʐMppCv̐Ɏs܂B");

	//	ϐ
	m_env += '\0';
	m_env += '\0';

	//	vZX\
	STARTUPINFO StartupInfo;

	::ZeroMemory(&StartupInfo, sizeof(STARTUPINFO));
	StartupInfo.cb = sizeof(STARTUPINFO);

	// nȟpw
	StartupInfo.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;

	// DOS\Ȃ
	StartupInfo.wShowWindow = SW_HIDE;

	// Wo̓nhƃG[o̓nhݒ
	StartupInfo.hStdOutput = m_hWritePipe;
	StartupInfo.hStdInput = m_hInReadPipe;
	StartupInfo.hStdError  = m_hErrWritePipe;


	// R\[AvN
	if (!::CreateProcess(
		NULL,
		command.GetBuffer(0),
		&m_sa,
		NULL,
		TRUE,				// nȟp
		0,	// DOS\Ȃ߂̎w
		m_env.GetPtr(),
		workPath,
		&StartupInfo,
		&m_processInfo))
	{
		TRACE("ErrCode : %d\n",GetLastError());
		throw CSubProcessException("vZX̋NɎs܂");
	}
	m_prosessCreated = TRUE;

	//	I܂őҋ@
	WaitProcessTerminate();

	return(0);
}


//	vZXI܂őҋ@EpCv̑M
void CSubProcess::WaitProcessTerminate()
{
	TIMEOUT_SCOPE();

	CBuffer	buf;
	int		index = 0;

	while(ProsessRunning())
	{
		//	StdIno
		index += WriteStdIn(m_stdin,index);

		//	StdOut`FbN
		if(ReadStdOut(buf) > 0)
			m_stdout += buf;

		//	StdErr`FbN
		if(ReadStdErr(buf) > 0)
			m_stderr += buf;

		//	^CAEg?
		if(IsTimeOut())
			throw CSubProcessException("vZXsɃ^CAEg܂");

		//	f?
		if(m_interrupt.IsInterrupt())
			throw CSubProcessException("vZXs" + m_interrupt.GetInterruptInfo());


		Sleep(10);
	}

	//	StdOut`FbN
	if(ReadStdOut(buf) > 0)
		m_stdout += buf;

	//	StdErr`FbN
	if(ReadStdErr(buf) > 0)
		m_stderr += buf;

	//
	//	fCxgmFĂ(bZ[W\̂)
	//

	//	^CAEg?
	if(IsTimeOut())
		throw CSubProcessException("vZXsɃ^CAEg܂");

	//	f?
	if(m_interrupt.IsInterrupt())
		throw CSubProcessException("vZXs" + m_interrupt.GetInterruptInfo());

}


//	StdOut擾
int CSubProcess::ReadStdOut(CBuffer &data)
{
	DWORD	stdInLen;
	if(!::PeekNamedPipe(m_hReadPipe, NULL, 0, NULL, &stdInLen, NULL))
		throw CSubProcessException("vZXԒʐMɎs܂");

	if(stdInLen > 0)
	{
		DWORD	readed;

		data.ReSize(stdInLen);
		if(!::ReadFile(m_hReadPipe,data.GetPtr(),stdInLen,&readed,NULL))
			throw CSubProcessException("vZXԒʐMɎs܂");
		data.ReSize(readed);
	
		return(readed);
	}

	data.ReSize(0);
	return(0);
}

//	StdErr擾
int CSubProcess::ReadStdErr(CBuffer &data)
{
	DWORD	stdInLen;
	if(!::PeekNamedPipe(m_hErrReadPipe, NULL, 0, NULL, &stdInLen, NULL))
		throw CSubProcessException("vZXԒʐMɎs܂");
	
	if(stdInLen > 0)
	{
		DWORD	readed;

		data.ReSize(stdInLen);
		if(!::ReadFile(m_hErrReadPipe,data.GetPtr(),stdInLen,&readed,NULL))
			throw CSubProcessException("vZXԒʐMɎs܂");
		data.ReSize(readed);

		return(readed);
	}

	data.ReSize(0);
	return(0);
}

//	StdIno
int CSubProcess::WriteStdIn(CBuffer &data,int startIndex)
{
	DWORD	dataLen = data.GetSize() - startIndex;
	char	*dataPtr = data.GetPtr() + startIndex;

	if(dataLen <= 0)
		return(0);

	//	o͂͏IH
	if(::WaitForSingleObject(m_hInWriteWait,0) == WAIT_OBJECT_0)
	{
		DWORD writeLen = BUFFER_SIZE;
		if(dataLen < writeLen)
			writeLen = dataLen;

		memset(&m_ovrlapped,0,sizeof(m_ovrlapped));
		m_ovrlapped.hEvent = m_hInWriteWait;

		DWORD	temp;

		//	o͂
		if(!::WriteFile(m_hInWritePipe,dataPtr,writeLen,&temp,&m_ovrlapped) && GetLastError() != ERROR_IO_PENDING)
			throw CSubProcessException("vZXԒʐMɎs܂");

		return(writeLen);
	}
	return(0);
}


//	pCv
int CSubProcess::CreatePipe(CString threadID)
{
	// ZLeB(nhpw)
	m_sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	m_sa.lpSecurityDescriptor = NULL;
	m_sa.bInheritHandle = TRUE;

	// Wo͗ppCv쐬
	if(!::CreatePipe(&m_hReadPipe, &m_hWritePipe, &m_sa, BUFFER_SIZE))
		return(-1);
	
	// G[o̓pCv̍쐬
	if(!::CreatePipe(&m_hErrReadPipe, &m_hErrWritePipe, &m_sa, BUFFER_SIZE))
		return(-1);

	// W̓pCv̍쐬
	m_hInWritePipe = CreateNamedPipe("\\\\.\\pipe\\_04WebServer_CGISSI_" + threadID,PIPE_ACCESS_OUTBOUND | FILE_FLAG_OVERLAPPED,
               PIPE_TYPE_BYTE, 1, BUFFER_SIZE, BUFFER_SIZE, 1000, NULL);

	if(m_hInWritePipe == INVALID_HANDLE_VALUE )
		return(-1);

	m_hInReadPipe = CreateFile("\\\\.\\pipe\\_04WebServer_CGISSI_" + threadID,GENERIC_READ, 0, &m_sa, OPEN_EXISTING, 0, NULL);
	if(m_hInReadPipe == INVALID_HANDLE_VALUE )
		return(-1);

	if(!::ConnectNamedPipe(m_hInWritePipe,NULL) && GetLastError() != ERROR_PIPE_CONNECTED)
		return(-1);

	m_hInWriteWait = CreateEvent(&m_sa,FALSE,TRUE,NULL);
	if(m_hInWriteWait == INVALID_HANDLE_VALUE )
		return(-1);

	return(0);
}


//	vZXs擾
int CSubProcess::ProsessRunning()
{
	if(!m_prosessCreated)
		return(0);

	DWORD ret = ::WaitForSingleObject(m_processInfo.hProcess, 0);

	if(ret == WAIT_TIMEOUT)
		return(1);
	return(0);
}

//	vZXI
void CSubProcess::TerminateProcess()
{
	//	sȂA~
	if(ProsessRunning())
	{
		::TerminateProcess(m_processInfo.hProcess,-1);
	}

	m_prosessCreated = 0;
}


//	I
void CSubProcess::Break()
{
	TerminateProcess();
}


//	^CAEg
void CSubProcess::OnTimeOut()
{
	Break();
}


//	̒ǉ
void CSubProcess::AddEnvironment(CString env)
{
	int index = env.Find("=");

	if(index != env.GetLength() - 1)
	{
		m_env += env;
		m_env += '\0';
	}
}


//	CGI̒ǉ
void CSubProcess::AddCGIServerEnvironment(CServer *server,CWorkspaceAccess context,CRequest request,CAlias alias)
{
	CWorkspace			env;
	CWorkspaceAccess	envAccess = env.GetAccess("Env");
	GetCGIServerEnvironment(envAccess,server,context,request,alias);

	CStringArray	list;
	envAccess.GetAllKey(list);

	for(int i=0;i<list.GetSize();i++)
	{
		AddEnvironment(list[i] + "=" + envAccess.GetConfig(list[i],""));
	}

	//	̊ϐ
	for(int i=0;_environ[i] && i<256;++i)
		AddEnvironment(_environ[i]);
}

/*!
 *	̈擾
 */
void CSubProcess::GetCGIServerEnvironment(CWorkspaceAccess env,CServer *server,CWorkspaceAccess context,CRequest request,CAlias alias)
{
	env.Clear();

	CString	str;

	//
	//	EFuT[oɊւϐXg
	//

	//	CGI vO NT[o\tgEGA̖Oƃo[WB
	env.SetConfig("SERVER_SOFTWARE",server->m_serverInfo.GetConfig("ServerSignature",""));

	//	T[õVOj`
	str.Format("<address>%s</address>",server->m_serverInfo.GetConfig("ServerSignature",""));
	env.SetConfig("SERVER_SIGNATURE",str);

	//	T[õzXgAhCA܂IPAhXB 
	env.SetConfig("SERVER_NAME",server->m_serverInfo.GetConfig("ServerHostName",""));

	//	T[ogpCGĨrW
	env.SetConfig("GATEWAY_INTERFACE","CGI/1.1");

	//	vgR̖OƃrWB
	env.SetConfig("SERVER_PROTOCOL","HTTP/1.1");

	//	T[õAhX
	env.SetConfig("SERVER_ADDR",server->m_serverInfo.GetConfig("ServerAddress",""));

	//	|[gԍB 
	env.SetConfig("SERVER_PORT",server->m_serverInfo.GetConfig("ServerPort",""));

	//	T[oiNCAg擾j
	if(!request.GetOptionAccess().GetConfig("Host","").IsEmpty())
		env.SetConfig("HTTP_HOST",request.GetOptionAccess().GetConfig("Host",""));
 




	//
	//	CGI ̏Ɋւϐ̃Xg
	//

	//	NGXg𑗐M@i\bhjBGETPOSTȂǁB 
	env.SetConfig("REQUEST_METHOD",request.GetMethod());

	//	POSTW͂ɑMꂽf[^̃oCgB 
	env.SetConfig("CONTENT_LENGTH",request.GetOptionAccess().GetConfig("Content-length","0",TRUE));
 
	//	POSTPUTȂǂ̃NGɓYtꂽf[^MIME^CvB
	env.SetConfig("CONTENT_TYPE",request.GetOptionAccess().GetConfig("Content-Type","",TRUE));

	//	NGƂđꂽURL̃NGX`( ? )ȍ~̏Bf[^́wURLGR[hxĂ܂B 
	env.SetConfig("QUERY_STRING",request.GetQuery());

 

	//	zpX
	env.SetConfig("SCRIPT_NAME",request.GetURIObject());

	//	URI
	env.SetConfig("REQUEST_URI",request.GetURI());

	//	PATH_INFO,PATH_TRANSLATED
	if(alias.IsExtarExist())
	{
		//	GNXgpX
		str = alias.GetExtraPath();
		str.Replace("\\","/");
		env.SetConfig("PATH_INFO",str);

		//	GNXgpXi[JpXɕϊj
		str = CDir::RemoveBackSlash(alias.GetPathInfo().GetConfig("LocalPath","Z:\\")) + alias.GetExtraPath();
		str.Replace("\\","/");
		env.SetConfig("PATH_TRANSLATED",str);

		//	΃pXB
		str = alias.GetExtraTarget();
		str.Replace("\\","/");
		env.SetConfig("SCRIPT_FILENAME",str);

		//	zpX̍Đݒ
		CString	uri = request.GetURIObject();
		if(uri.GetLength() > alias.GetExtraPath().GetLength())
			uri = uri.Left(uri.GetLength() - alias.GetExtraPath().GetLength());
		env.SetConfig("SCRIPT_NAME", uri);

	}
	else
	{
		//	΃pXB
		str = alias.GetTarget();
		str.Replace("\\","/");
		env.SetConfig("SCRIPT_FILENAME",str);
	}


	//
	//	NCAgɊւϐ̃Xg
	//

	//	[UF؂ƂɎgpF؃\bhBEFuT[oƃ[gzXgIDENTDF؃f[i[UF؃vgRjsĂƂlB 
	env.SetConfig("AUTH_TYPE","basic");

	//	NCAg󂯕t邱ƂłMIME^CṽXgB 
	env.SetConfig("HTTP_ACCEPT",request.GetOptionAccess().GetConfig("Accept","*/*",TRUE));

	//	NCAgNGXg𔭍sƂɎgpuEU 
	env.SetConfig("HTTP_USER_AGENT",request.GetOptionAccess().GetConfig("User-Agent","*/*",TRUE));
 
	//	ĂяoURLBAhXo[̒ړ́AubN}[ÑANZX̍ۂɂ͒l܂B 
	env.SetConfig("HTTP_REFERER",request.GetOptionAccess().GetConfig("Referer","",TRUE));

	//	[gzXgIPAhXB 
	env.SetConfig("REMOTE_ADDR",context.GetConfig("Host",""));

	//	[gzXg̃zXgB 
	if(server->m_setting.GetConfig("CGIEnvironment::EnableGetHostName",0))
	{
		CIPAddress	ip = context.GetConfig("Host","");
		env.SetConfig("REMOTE_HOST",ip.GetHostName());
	}

	//	[U̔FؖBEFuT[oƃ[gzXgIDENTDF؃f[i[UF؃vgRjsĂƂl܂B 
	env.SetConfig("REMOTE_USER",request.GetUser());

	//	[U̔FؖBEFuT[oƃ[gzXgIDENTDF؃f[i[UF؃vgRjsĂƂl܂B 
	env.SetConfig("AUTH_USER",request.GetUser());

 	//	[ŨpX[hBEFuT[oƃ[gzXgIDENTDF؃f[i[UF؃vgRjsĂƂl܂B 
	env.SetConfig("AUTH_PASSWORD",request.GetPasswd());


	//	[U̔Fؖ 
	env.SetConfig("PHP_AUTH_USER",request.GetUser());

 	//	[ŨpX[h
	env.SetConfig("PHP_AUTH_PW",request.GetPasswd());


	//
	//	vNV
	//

	//	vLVT[o[̏񂪐ݒ肳܂
	env.SetConfig("HTTP_VIA",request.GetOptionAccess().GetConfig("Via","",TRUE));

	//	LVT[o[̏񂪐ݒ肳܂B
	env.SetConfig("HTTP_FORWARDED",request.GetOptionAccess().GetConfig("Forwarded","",TRUE));

	//	vLVT[o[ւ̎w
	env.SetConfig("HTTP_PROXY_CONNECTION",request.GetOptionAccess().GetConfig("Proxy-Connection","",TRUE));


	//
	//	̑
	//

	//	NbL[
	env.SetConfig("HTTP_COOKIE",request.GetOptionAccess().GetConfig("Cookie","",TRUE));

}


/*!
 *	Ps擾
 */
CString	CSubProcess::GetFirstLine(CString path)
{
	CString	ret;
	FILE	*text;

	if(!fopen_s(&text, path,"rb"))
	{
		char *buf = ret.GetBuffer(256);

		if(buf)
			fgets(buf,255,text);

		fclose(text);
		ret.ReleaseBuffer();
		return(ret);
	}
	else
		return("");
}


