#pragma once

class CTextTools
{
public:

	//////////////////////////////////////////////////////////////
	//	񏈗iϊj
	//////////////////////////////////////////////////////////////
	//!	ꂽ擾
	static CString GetFormat(LPCTSTR lpszFormat, ...);

	//!	int64֕ϊ
	static __int64 strtoi64(CString str,int  base);

	//////////////////////////////////////////////////////////////
	//	񏈗i؂oj
	//////////////////////////////////////////////////////////////
	//!	s̐؂o
	static int GetLine(CString &str, CString &line);

	//!	g[N̐؂o
	static int GetToken(CString &str, CString &token, CString div, int trim = FALSE);

	//!	g[NSĐ؂o
	static void GetAllToken(CString str, CStringArray &tokens, CString div, int trim = FALSE);

	//!	g[N̐؂o(_uR[e[Vɂ镶ɑΉ)
	static int GetTokenDoubleQuotation(CString &str, CString &token, CString div, int trim = FALSE);

	//!	g[NSĐ؂o(_uR[e[Vɂ镶ɑΉ)
	static void GetAllTokenDoubleQuotation(CString str, CStringArray &tokens, CString div, int trim = FALSE);

	//!	Õ_uR[e[V
	static CString RemoveDoubleQuotation(CString str);

	//////////////////////////////////////////////////////////////
	//	ChJ[hr
	//////////////////////////////////////////////////////////////
	//!	ChJ[hŔr
	static int WildCompare(CString wild,CString str);

	//////////////////////////////////////////////////////////////
	//	z񏈗
	//////////////////////////////////////////////////////////////
	//!	z񂩂當
	static int FindStrIndex(CStringArray &list, CString find, int noCase = 0);

	//////////////////////////////////////////////////////////////
	//	ϊ
	//////////////////////////////////////////////////////////////
	//!	UnicodeAANSI
	static CStringA	WideStrToMultiStr(const wchar_t *str);

	//!	MBAUnicode
	static CStringW	MBStrToWideStr(const char *str);

	//!	MBUTF8
	static CStringA	MBStrToUTF8Str(const char *str);

	//!	UTF8MB
	static CStringA	UTF8ToMBStr(const char *str);

	//!	UnicodeUTF8
	static CStringA	WideStrToUTF8Str(const wchar_t *str);

	//!	UTF8
	static CStringA StrToUTF8(CString str);


private:
	//////////////////////////////////////////////////////////////
	//	ChJ[hr
	//////////////////////////////////////////////////////////////
	static int StrMatch( const char *Ptn, const char *Str );
};


/*!
	uNX
*/
class CTextEscape
{
public:
	class CTextEscapeItem
	{
	public:
		CTextEscapeItem() {};
		CTextEscapeItem(CString	token, CString escape)
		{
			m_token = token;
			m_escape = escape;
		};

		CString	m_token;
		CString	m_escape;
	};

	///////////////////////////////////////////////////////////////////////////
	//	̃GXP[v
	///////////////////////////////////////////////////////////////////////////
	//!	GXP[v̎s
	CString Escape(CString src);

	//!	GXP[v̉
	CString UnEscape(CString escaped);

	//!	ǉ
	void AddEscape(CString token, CString escape);

	//!	NA
	void Clear();

protected:
	///////////////////////////////////////////////////////////////////////////
	//	̃GXP[v
	///////////////////////////////////////////////////////////////////////////
	//!	ԍŏɌCfbNX擾
	int MultiFind(int startIndex, int &findIndex, CString &src, CArray<CTextEscapeItem> &items);

	///////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////
	//!	u
	CArray<CTextEscapeItem>	m_escape;

	//!	u
	CArray<CTextEscapeItem>	m_unescape;
};