#pragma once

#include "SyncObject.h"


/*!
	class CThreadSkeleton

	Xbh̃x[Xł
*/
class CThreadSkeleton
{
protected:
	CCriticalSection	m_scopeLock;

public:
	CThreadSkeleton(void);
	virtual ~CThreadSkeleton(void);

public:
	////////////////////////////////////////////////////////////////////////////////////////////
	//	JnEIEf
	////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xbh̎sJn
	int StartThread(int stackSize=0);

	//!	Xbh̏Iifj
	void EndThread();

	//!	fw
	virtual void Break();

	//!	IiʂȗRAgp֎~j
	virtual void ForceKillThread();

	////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^X
	////////////////////////////////////////////////////////////////////////////////////////////
	//!	s擾(StartThread\bhs͗p֎~)
	int IsRunning();

	//!	fw擾
	int GetBreak();

	//!	fCxg擾
	HANDLE GetBreakEvent() { return m_breakEvent; };

	//!	Xbhnh擾
	HANDLE GetThreadHandle() { return m_thread; };

	////////////////////////////////////////////////////////////////////////////////////////////
	//	c[֐
	////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃IuWFNg҂
	static int WaitForSomeObjects(int timeoutMs,HANDLE obj1, HANDLE obj2=NULL, HANDLE obj3=NULL, HANDLE obj4=NULL);

protected:
	////////////////////////////////////////////////////////////////////////////////////////////
	//	Xbh֐
	////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xbh̏
	virtual void ThreadMain() = 0;

	//!	Xbh̏
	void _ThreadMain();
	
protected:
	////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	////////////////////////////////////////////////////////////////////////////////////////////
	//!	MFCXbhIuWFNg
	CWinThread			*m_thread;

	//!	Xbhnh
	HANDLE				m_hThread;

	//!	fCxg
	CSyncEvent			m_breakEvent;

	//!	sNX
	char				*m_className;

	//!	s֐
	char				*m_functionName;


private:
	static UINT WorkThread(LPVOID pParam);
};

//!	NXݒ
#define	DEBUG_SET_THREAD_CLASS_NAME(name)	{ m_className = name; };

//!	֐ݒ
#define	DEBUG_SET_THREAD_FUNCTION_NAME(name)	{ m_functionName = name; };