/*!
	CGIǗNX

	CGI̎śACGIs𐶐Ăs

	CCGIProcessBase -> CFastCGIProcess
	                -> CNormalCGIProcess
*/
#pragma once
#include "TextInfoExceptionBase.h"
#include "InterruptEvents.h"
#include "SortArray.h"
#include "Buffer.h"
#include "Workspace.h"

/*!
	vZX^Cv
*/
enum CGI_PROCESS_TYPE
{
	CGI_PROCESS_TYPE_EXECUTABLE		= 0,
	CGI_PROCESS_TYPE_SCRIPT			= 1,
};


/*!
	C^tF[X^Cv
*/
enum CGI_INTERFACE_TYPE
{
	CGI_INTERFACE_TYPE_CGI			= 0,
	CGI_INTERFACE_TYPE_FASTCGI		= 1,
};

/*!
	G[^Cv
*/
enum CGI_NEW_PROCESS_ERROR
{
	CGI_NEW_PROCESS_ERROR_NOERROR				= 0,

	//!	vZX
	CGI_NEW_PROCESS_ERROR_OVER_PROCESS			= -10,
};


/*!
	CGIvZXG[O
*/
DEFINE_TEXT_INFO_EXCEPTION(CCGIProcessException);


/*!
	CGIsC^[tF[X

	C^v^{XNvǵANXɎw
*/
class ICGIInterface
{
public:
	///////////////////////////////////////////////////////////////////////////////
	//	C^tF[X
	///////////////////////////////////////////////////////////////////////////////
	/*!
		1:CGIsJn(throw CCGIProcessException)

		\param envs:CGI̊ϐ
	*/
	virtual void StartCGIProcess(CKeyDataArray &envs) = 0;

	/*!
		2:NGXg{fB(throw CCGIProcessException)

		0݂ŏI
	*/
	virtual void WriteRequestBody(CBuffer &data, CInterruptEvents &breakEvents) = 0;

	/*!
		3:X|X̐
	*/
	virtual void WaitResponse(CInterruptEvents &breakEvents) = 0;

	/*!
		4:X|Xwb_擾(throw CCGIProcessException)

		SSIs͌ĂяoȂ
	*/
	virtual void ReadResponseHeader(CKeyDataArray &resHeaders, CInterruptEvents &breakEvents) = 0;

	/*!
		5:X|X{fBǂݏo(throw CCGIProcessException)

		0ǂݏoŏI
	*/
	virtual void ReadResponseBody(CBuffer &data, CInterruptEvents &breakEvents) = 0;

	/*!
		6:CGIsI
	*/
	virtual void CleanupCGIProcess() = 0;
};


/*!
	CGIǗNX

	CGIsAFastCGI̊Ǘs
	}l[ẂAJnAOX[Ȃ
*/
class CCGIManager
{
public:
	CCGIManager(void);
	virtual ~CCGIManager(void);

	///////////////////////////////////////////////////////////////////////////////
	//	C^tF[X
	///////////////////////////////////////////////////////////////////////////////
	//!	Jn(throw CServerStartException)
	void Start(CWorkspaceAccess setting);

	//!	~
	void Stop();

	//!	vZX擾(throw CCGIProcessException)
	int GetNewCGIProcess(CString commandLine, int cgiInterfaceType, int cgiProcessType, ICGIInterface **process);

	//!	vZXgpI
	void DeleteCGIProcess(ICGIInterface *process);

protected:
	///////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////

	///////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////
	//!	XR[vیp
	CCriticalSection	m_scopeLock;

	//!	őCGIvZX
	int					m_maxCGIProcessCount;

	//!	s̃vZX
	CTypedPtrArray<CPtrArray, ICGIInterface*>	m_processList;
};

