#pragma once
#include "Workspace.h"
#include "threadskeleton.h"
#include "response.h"
#include "request.h"
#include "alias.h"
#include "bandwidthmgr.h"
#include "ProtocolSocket.h"
#include "AcceptedSocketQueue.h"
#include "TextInfoExceptionBase.h"
#include "InterruptEvents.h"

/*!
	ڑ̏
*/
enum CONNECTION_PROCESS_STATUS
{
	CONNECTION_PROCESS_NOCHANGE				= -1,

	CONNECTION_PROCESS_STARTING				= 0,
	CONNECTION_PROCESS_RECVING_HEADER		= 1000,
	CONNECTION_PROCESS_RESTART				= 2000,
	CONNECTION_PROCESS_PRECREATING_RESPONSE	= 3000,
	CONNECTION_PROCESS_RECVING_BODY			= 4000,
	CONNECTION_PROCESS_CREATING_RESPONSE	= 5000,
	CONNECTION_PROCESS_SENDING_HEADER		= 6000,
	CONNECTION_PROCESS_SENDING_BODY			= 7000,
	CONNECTION_PROCESS_COMPLETE				= 8000,
};


/*
	NX炩ߐ錾
*/
class CServer;
class CConnection;
class CConnectionInterrupt;


/*!
	G[O
*/
DEFINE_TEXT_INFO_EXCEPTION(CConnectionException);

/*!
	G[O
*/
DEFINE_TEXT_INFO_EXCEPTION(CServerFatalException);


/*!
	X|X̒fmF
*/
class CConnectionInterrupt : public CInterruptEvents
{
public:
	CConnectionInterrupt(CConnection *connection);
	CConnectionInterrupt(CConnectionInterrupt &other);
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	ߋ̌݊
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	fmF
	operator int();

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	CInterruptEvents
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	fmF
	virtual int IsInterrupt();

	//!	f擾
	virtual CString GetInterruptInfo();

	//!	fҋ@
	virtual int WaitInterrupt(int timeout);

	//!	fCxgׂĎ擾
	virtual void GetAllInterruptEvents(CArray<HANDLE> &events);

private:
	//!	e̐ڑ
	CConnection		*m_connection;

	//!	ؒf
	CString			m_interruptInfo;
};


/*!
	ڑNX
*/
class CConnection : public CThreadSkeleton
{
	friend class CConnectionInterrupt;

public:
	//!	ڑ𐶐
	CConnection(CServer *server, CAcceptedSocket newSocket);

	//!	ڑj
	virtual ~CConnection(void);

	//!	𒆒f
	virtual void Break();

protected:
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	ڑ
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C[v
	void ThreadMain();

	//!	Ή\Pbgbp
	CProtocolSocket *CreateProtocolSocket(SOCKET socket, int socketType);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	PNGXg
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	1NGXg
	int OneRequest(CWorkspaceAccess context);

	//!	X^[g(X^[gs̏ꍇ́AO𓊂)
	void RestartConnectionProcess(CWorkspaceAccess &contex);

	//!	VReLXg𐶐
	CWorkspaceAccess NewContext();

	//!	ReLXgj	
	void DeleteContext(CWorkspaceAccess context);

	//	O֏o
	void WriteLog(CWorkspaceAccess &context);


	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ׂ`FbN
	void CheckServerOverload(CWorkspaceAccess &context);

	//!	ANZX`FbN
	void CheckAccess(CWorkspaceAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef);

	//!	F؃`FbN
	void CheckAuthorize(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	zXg`FbN
	int CheckKickHost(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	ړ̊mF
	void CheckMove(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	WebDAV
	void WebDAV(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	IndexmF
	void CheckIndex(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	CGI
	void CGI(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	SSI
	void SSI(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	ʐM
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_M
	CString RecvHeader();

	//!	X|XiNGXg{fBMAX|XAX|Xwb_MAX|X{fBMj
	void SendResponse(CWorkspaceAccess &context, CRequest &request, CAlias &alias, CBandWidthReference &bandRef, CResponse *response);

	//!	NGXg{fBM
	void RecvData(CWorkspaceAccess &context, CRequest &request, CAlias &alias,CBandWidthReference &bandRef, CResponse *response);

	//!	X|X{fBM
	void SendData(CWorkspaceAccess &context, CRequest &request, CAlias &alias, CBandWidthReference &bandRef, CResponse *response, __int64 length);

	//!	vIG[𑗐M
	void SendFatalError(CString info);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	c[֐
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_𐶐
	CString MakeHeaderString(CWorkspaceAccess responseInfo);

	//!	[UL`FbN
	int CheckUser(CString userName, CString passwd, CAlias alias);

	//!	ш搧pEFCg
	void Delay(int tick);
	
	//!	X|X𑗐M\ȏԂ`FbN
	int CanSendResponse(CWorkspaceAccess &context);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^X
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	MTCYXV
	void UpdateTransSize(CWorkspaceAccess &context);

	//!	󋵕ύX
	void UpdateConnectionStatus(CWorkspaceAccess &context, CString statusString, CONNECTION_PROCESS_STATUS statusCode = CONNECTION_PROCESS_NOCHANGE, int isRestart = FALSE); 

	//!	󋵂擾
	CONNECTION_PROCESS_STATUS GetConnectionProcessStatus(CWorkspaceAccess &context);

protected:
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	^CAEg
	int						m_serverTimeout;

	//!	KeepAlive
	int						m_maxKeepAliveTime;

	//!	KeepAlive
	int						m_keepAlive;

	//!	tp̈
	CWorkspace				m_date;

	//!	Mς݃f[^TCY
	__int64					m_sendSize;

	//!	Mς݃f[^TCY
	__int64					m_recvSize;

	//!	Mς݃NGXg{fBTCY
	__int64					m_recvDataSize;;

	//!	T[o
	CServer					*m_server;

	//!	fǗNX
	CConnectionInterrupt	m_interrupt;

	//!	\Pbg
	SOCKET					m_rawSocket;

	//!	\Pbg^Cv
	int						m_rawSocketType;

	//!	\Pbgbp
	CProtocolSocket			*m_protocolSocket;
};

