#pragma once
#include "AuthenticateManager.h"
#include "Workspace.h"
#include "Request.h"
#include "Alias.h"

enum AUTH_PARSE_STATUS
{
	//	F؏Ȃ
	AUTH_PARSE_STATUS_NONE		= 0,

	//	F؏؂
	AUTH_PARSE_STATUS_EXPIRE	= 10,

	//	F؎s
	AUTH_PARSE_STATUS_FAILE		= 20,

	//	Fؐ
	AUTH_PARSE_STATUS_OK		= 30,

	//	ُȔF
	AUTH_PARSE_STATUS_ERROR		= -1,
};

/*!
	_CWFXgF؃NX
*/
class CDigestAuthenticate
{
public:
	/////////////////////////////////////////////////////////////////////////////////////////
	//	`FbN
	/////////////////////////////////////////////////////////////////////////////////////////
	//!	Fؕ
	static AUTH_PARSE_STATUS ParseAuthMethod(CAuthenticateManager *manager, CAlias &alias, CRequest &request);

	/////////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////////
	//!	F؃C擾
	static CString GetAuthOptionLine(int isDigest, CAuthenticateManager *manager, CAlias &alias, int stale);

	//!	F؃C擾
	static CString GetBasicAuthOptionLine(CAlias &alias);

	//!	F؃C擾
	static CString GetDigestAuthOptionLine(CAuthenticateManager *manager, CAlias &alias, int stale);

protected:
	/////////////////////////////////////////////////////////////////////////////////////////
	//	BasicF
	/////////////////////////////////////////////////////////////////////////////////////////
	//!	{F؂̕
	static int ParseBasicAuth(CString authLine, CRequest &request);

	//!	{F؂̔F؃`FbN
	static int CheckBasicAuthUser(CAuthenticateManager *manager, CAlias &alias, CRequest &request);


	/////////////////////////////////////////////////////////////////////////////////////////
	//	DigestF
	/////////////////////////////////////////////////////////////////////////////////////////
	//!	_CWFXgF؂𕪐
	static int ParseDigestAuth(CString optionLine, CRequest &request);

	//!	_CWFXgF؂̏ڍ׃`FbN
	static int CheckDigestAuthRequest(CAuthenticateManager *manager, CAlias &alias, CRequest &request);

	//!	X|X`FbN
	static int CheckDigestAuthResponse(CAuthenticateManager *manager, CAlias &alias, CRequest &request, CString tag = _T(""));

	//!	`FbN
	static int CheckDigestAuthExpire(CAuthenticateManager *manager, CAlias &alias, CRequest &request);

	//!	F؃`FbN
	static int CheckDigestAuthUser(CAuthenticateManager *manager, CAlias &alias, CRequest &request);


	/////////////////////////////////////////////////////////////////////////////////////////
	//	⏕֐
	/////////////////////////////////////////////////////////////////////////////////////////
	//!	[UEpX[hmF
	static int GetUserPasswd(CAuthenticateManager *manager, CAlias &alias, CString userName, CString &passwd);

	//!	URÏvmF
	static int CheckURIMatch(CString serverURI, CString clientURI);

	//!	realm擾
	static CString GetRealm(CString realmSrc);
};
