#include "StdAfx.h"
#include "SecDesc.h"
#include <aclapi.h >

CSecDesc::CSecDesc(void)
{
	m_eaCount = 0;
	m_pDacl = NULL;
}

CSecDesc::~CSecDesc(void)
{
	m_eaCount = 0;
	if(m_pDacl)
	{
		::LocalFree(m_pDacl);
		m_pDacl = NULL;
	}

	for(int i=0;i<m_trustyNames.GetCount();i++)
		delete m_trustyNames[i];
	m_trustyNames.RemoveAll();
}


///////////////////////////////////////////////////////////////////////////////////////////////
//	SD
///////////////////////////////////////////////////////////////////////////////////////////////
/*!
	SD
*/
int CSecDesc::BuildSA()
{
	//	SD
	InitializeSecurityDescriptor(&m_sd, SECURITY_DESCRIPTOR_REVISION);

	//	DACL
	if(SetEntriesInAcl(m_eaCount, m_ea, NULL, &m_pDacl) != ERROR_SUCCESS )
	{
		TRACE("%d\n", GetLastError());
		return(-1);
	}

	//	SD֐ݒ
	SetSecurityDescriptorDacl(&m_sd, TRUE, m_pDacl, FALSE);

	//	ASݒ
	m_sa.nLength              = sizeof(SECURITY_ATTRIBUTES);
	m_sa.bInheritHandle       = FALSE;
	m_sa.lpSecurityDescriptor = &m_sd;

	return(0);
}

/*!
	LocalSA
*/
int CSecDesc::BuildLocalSA(DWORD AccessPermissions)
{
	if(AddUserByName("Local", AccessPermissions, GRANT_ACCESS, NO_INHERITANCE))
		return(-1);

	//	ǉ
	AddUserByName(GetCurrentProcessUser(), AccessPermissions, GRANT_ACCESS, NO_INHERITANCE);

	if(BuildSA())
		return(-1);

	return(0);
}

///////////////////////////////////////////////////////////////////////////////////////////////
//	[U̒ǉ
///////////////////////////////////////////////////////////////////////////////////////////////
/*!
	[Uǉ
*/
int CSecDesc::AddUserByName(CString name, DWORD AccessPermissions, ACCESS_MODE AccessMode, DWORD Inheritance)
{
	if(m_eaCount >= MAX_EA)
		return(-1);

	if(name.IsEmpty())
		return(-1);

	//	gXeBRs[
	m_trustyNames.Add(new char[name.GetLength() + 1]);
	strcpy_s(m_trustyNames[m_eaCount], name.GetLength() + 1, name);

	BuildExplicitAccessWithName(&m_ea[m_eaCount], m_trustyNames[m_eaCount], AccessPermissions, AccessMode, Inheritance);
	m_eaCount++;
	return(0);
}


/*I
	݂̃[U擾
*/
CString CSecDesc::GetCurrentProcessUser()
{
	HANDLE	hToken;
	if(!OpenProcessToken(::GetCurrentProcess(), TOKEN_READ, &hToken))
	{
		//	G[
		return("");
	}
	else
	{
		UCHAR InfoBuffer[1000],szAccountName[MAX_PATH], szDomainName[MAX_PATH];
		PTOKEN_USER pTokenUser = (PTOKEN_USER)InfoBuffer;
		DWORD dwInfoBufferSize,dwAccountSize = MAX_PATH, dwDomainSize = MAX_PATH;
		SID_NAME_USE snu;

		if(!GetTokenInformation(hToken,TokenUser,InfoBuffer, 1000, &dwInfoBufferSize))
		{
			SAFE_CLOSE_HANDLE(hToken);
			return("");
		}

		if(!LookupAccountSid(NULL, pTokenUser->User.Sid, (LPSTR)szAccountName, &dwAccountSize,(LPSTR)szDomainName, &dwDomainSize, &snu))
		{
			SAFE_CLOSE_HANDLE(hToken);
			return("");
		}

		SAFE_CLOSE_HANDLE(hToken);

		return(CString(szAccountName));
	}
}
