${header}package ${package}.dao;

import java.util.List;

import ${package}.dto.${table.tableNameForDto?cap_first}Dto;
import ${package}.finddto.${table.tableNameForDto?cap_first}FindDto;

/**
 * ${table.tableName}テーブルに対応するDaoです。
 * @author S2Dao-CodeGen
 */
public interface ${table.tableNameForDto?cap_first}Dao {

    /**
     *  ${table.tableNameForDto?cap_first}Dtoに対応するBEANアノテーションです。
     */
    public Class BEAN = ${table.tableNameForDto?cap_first}Dto.class;

	<#assign primarys=table.primaryKey>

	<#if primarys?size = 1 >
	<#assign primaryField=primarys?first>
	/**
	 * getAll${table.tableNameForDto?cap_first}メソッドに対応するQUERYアノテーションです。
	 */
    public String getAll${table.tableNameForDto?cap_first}_QUERY = "ORDER BY ${primaryField.field.fieldName}";

	</#if>
	/**
	 * ${table.tableName}のEntityを全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
    public List<#if useGenerics><${table.tableNameForDto?cap_first}Dto></#if> getAll${table.tableNameForDto?cap_first}();


	<#if primarys?size = 1 >
	<#assign primaryField=primarys?first>
	<#assign javaTypeName=primaryField.field.dataType.langDataType.className>
	/**
	 * get${table.tableNameForDto?cap_first}メソッドに対応するQUERYアノテーションです。
	 */
    public String get${table.tableNameForDto?cap_first}_QUERY = "${primaryField.field.fieldName} = ?";

	/**
	 * 引数が主キーと一致する${table.tableName}のEntityを取得します。
	 *
	 * @param ${primaryField.field.fieldNameForDto} 主キー
	 * @return Entity
	 */
    public ${table.tableNameForDto?cap_first}Dto get${table.tableNameForDto?cap_first}(${javaTypeName} ${primaryField.field.fieldNameForDto});
	</#if>

	<#if primarys?size = 1 >
	<#assign primaryField=primarys?first>
	<#assign javaTypeName=primaryField.field.dataType.langDataType.className>

	/**
	 * get${table.tableNameForDto?cap_first}ByIdsメソッドに対応するARGSアノテーションです。
	 */
    public String get${table.tableNameForDto?cap_first}ByIds_ARGS = "${primaryField.field.fieldNameForDto}s";

	/**
	 * get${table.tableNameForDto?cap_first}ByIds_QUERYメソッドに対応するQUERYアノテーションです。
	 */
    public String get${table.tableNameForDto?cap_first}ByIds_QUERY = "${primaryField.field.fieldName} in /*${primaryField.field.fieldNameForDto?uncap_first}s*/(1) ORDER BY ${primaryField.field.fieldName}";

	/**
	 * 引数が主キーと一致する${table.tableName}のEntityのリストを主キーでソートして取得します。
	 *
	 * @param ${primaryField.field.fieldNameForDto?uncap_first}s  主キーのリスト
	 * @return Entityのリスト
	 */
    public List<#if useGenerics><${table.tableNameForDto?cap_first}Dto></#if> get${table.tableNameForDto?cap_first}ByIds(List ${primaryField.field.fieldNameForDto?uncap_first}s);
	</#if>
    
	/**
	 * findメソッドに対応するARGSアノテーションです。
	 */
    public String find_ARGS = "dto";


	/**
	 * FindDtoに指定した検索条件と一致するEntityのリストを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entityのリスト
	 */
    public List<#if useGenerics><${table.tableNameForDto?cap_first}Dto></#if> find(${table.tableNameForDto?cap_first}FindDto dto);

	/**
	 * FindDtoに指定した検索条件と一致するEntityを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entity
	 */
    public ${table.tableNameForDto?cap_first}Dto soleMatch(${table.tableNameForDto?cap_first}FindDto dto);
    
	/**
	 * Entityを追加します。
	 *
	 * @param dto Entity
	 */
    public void insert(${table.tableNameForDto?cap_first}Dto dto);
    
	/**
	 * Entityを更新します。更新結果が0件の場合は、org.seasar.dao.NotSingleRowUpdatedRuntimeExceptionがスローされます。
	 *
	 * @param dto Entity
	 */
    public void update(${table.tableNameForDto?cap_first}Dto dto);
    
	/**
	 * Entityを削除します。削除結果が0件の場合は、org.seasar.dao.NotSingleRowUpdatedRuntimeExceptionがスローされます。
	 *
	 * @param dto Entity
	 */
    public void delete(${table.tableNameForDto?cap_first}Dto dto);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します。更新結果が0件の場合は、org.seasar.dao.NotSingleRowUpdatedRuntimeExceptionがスローされます。
	 * <p>このメソッドを使用する場合は、dao.diconでorg.seasar.dao.impl.BeanEnhancerImplを指定してください。</p>
	 *
	 * @param dto Entity
	 */
    public void updateModifiedOnly(${table.tableNameForDto?cap_first}Dto dto);

}

