/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.ListIterator;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;

public class CodeGenMain {

    public void execute() {

        SingletonS2ContainerFactory.init();
        S2Container s2 = SingletonS2ContainerFactory.getContainer();
        try {
            s2.init();
            DirectoryList dirList = (DirectoryList) s2.getComponent("path");
            for (int i = 0; i < dirList.getList().size(); i++) {
                String diconDir = (String) s2.getComponent("diconDir");
                doGenarate(s2, diconDir, (Directory) dirList.getList().get(i));
            }
        } finally {
            s2.destroy();
        }
    }

    protected void doGenarate(S2Container s2, String diconDir,
            Directory directory) {
        File dir;

        if (StringUtil.isEmpty(directory.getPath())) {
            dir = new File(diconDir);
        } else {
            dir = new File(diconDir + "/" + directory.getPath());
        }
        if (!dir.exists()) {
            throw new RuntimeException("directory does not exist [" + dir + "]");
        }
        String[] diconFileNames = dir.list(new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return (name.endsWith(".dicon") && (!("ERWinCSV.dicon"
                        .equals(name))));
            }
        });

        ListIterator iter = Arrays.asList(diconFileNames).listIterator();
        if (!iter.hasNext()) {
            throw new RuntimeException("diconFile is empty. path = " + diconDir
                    + directory.getPath());
        }
        do {
            String path = directory.getPath() + "/" + (String) iter.next();

            EachGen eachGen = new EachGen();
            eachGen.setDiconPath(path);
            eachGen.setCsvFile(new File((String) s2.getComponent("inputFile")));
            eachGen.setDestinationDir(new File(directory.getDestination()));
            eachGen.setPackageName((String) s2.getComponent("packageName"));
            eachGen.setTemplateDir((String) s2.getComponent("templateDir"));

            eachGen.generate();
        } while (iter.hasNext());
    }

}
