/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/**
 * 
 */
package org.seasar.codegen.dbms;

import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.exception.NotTypeMatchException;

/**
 * @author azusa
 * 
 */
public class MSSQLServer extends AbstractDataTypeSelectUtil {

    public String convDBTypeToDataType(String typeName) {
        return typeName;
    }

    public DataType selectBestDataType(FieldSetting fieldSetting) {
        String typeName = fieldSetting.getTypeName();
        fieldSetting.setRdbType(fieldSetting.getTypeName());
        DataType dataType = null;

        if (typeName.startsWith("BIGINT")) {
            dataType = getAnyDataType(fieldSetting, "long");
        } else if (typeName.startsWith("TIMESTAMP")) {
            dataType = getAnyDataType(fieldSetting, "byte[]");
        } else if (typeName.startsWith("BINARY")) {
            dataType = getAnyDataType(fieldSetting, "byte[]");
        } else if (typeName.startsWith("BIT")) {
            dataType = getAnyDataType(fieldSetting, "boolean");
        } else if (typeName.startsWith("CHARNCHAR")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("DECIMAL")) {
            dataType = getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("MONEY")) {
            dataType = getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("SMALLMONEY")) {
            dataType = getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("FLOAT")) {
            dataType = getAnyDataType(fieldSetting, "double");
        } else if (typeName.startsWith("FLOAT")) {
            dataType = getAnyDataType(fieldSetting, "double");
        } else if (typeName.startsWith("INT")) {
            dataType = getAnyDataType(fieldSetting, "int");
        } else if (typeName.startsWith("IMAGE")) {
            dataType = getAnyDataType(fieldSetting, "byte[]");
        } else if (typeName.startsWith("TEXT")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("NTEXT")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("NUMERIC")) {
            dataType = getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("REAL")) {
            dataType = getAnyDataType(fieldSetting, "float");
        } else if (typeName.startsWith("SMALLINT")) {
            dataType = getAnyDataType(fieldSetting, "short");
        } else if (typeName.startsWith("TINYINT")) {
            dataType = getAnyDataType(fieldSetting, "short");
        } else if (typeName.startsWith("DATETIME")) {
            dataType = getAnyDataType(fieldSetting, "Timestamp");
        } else if (typeName.startsWith("SMALLDATETIME")) {
            dataType = getAnyDataType(fieldSetting, "Timestamp");
        } else if (typeName.startsWith("VARBINARY")) {
            dataType = getAnyDataType(fieldSetting, "byte[]");
        } else if (typeName.startsWith("VARCHAR")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("NVARCHAR")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("UNIQUEINDENTIFIER")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else {
            throw new NotTypeMatchException(fieldSetting.getTypeName());
        }

        return dataType;

    }

    public String getSuffix() {
        return "mssql";
    }

}
