${header}<#include "macro/FindProperty.ftl"/>
package ${package}.${defaultDir?lower_case};

<#assign importList=table.fieldImportDef>
<#list table.fieldImportDef as importName>
import ${importName};
</#list>
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.dao.pager.DefaultPagerCondition;

public class ${table.tableNameForDto?cap_first}${defaultDir} extends DefaultPagerCondition {

	private static final long serialVersionUID = 1L;

	public static final String TABLE = "${table.tableName}";
	private ArrayList orderList = new ArrayList();
	
	<@field table=table tableName=""/>

	<@proerty table=table tableName=""/>

	public void addOrderList(String order) {
		orderList.add(order);
	}

	public void addOrderList(String order,boolean isAsc) {
		orderList.add(order);
		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.getClass());
		String orderTarget = order.replaceAll("_","");
		orderTarget = orderTarget.replaceAll("\\.", "_") + "_isASC";
		if (beanDesc.hasPropertyDesc(orderTarget)) {
			PropertyDesc propDesc = beanDesc.getPropertyDesc(orderTarget);
			propDesc.setValue(this, Boolean.valueOf(isAsc));
		} else {
			throw new IllegalArgumentException("Cannot found property " + order);
		}
	}
	
	public String getOrderList() {
		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.getClass());
		String ORDER = "ORDER BY ";
		Iterator ite = orderList.iterator();
		StringBuffer buf = new StringBuffer();
		while (ite.hasNext()) {
			String orderTgt = (String) ite.next();
			buf.append(ORDER);
			buf.append(orderTgt);
			buf.append(" ");
			PropertyDesc propDesc = null;
			String orderProp = orderTgt.replaceAll("_","").replaceAll("\\.", "_") + "_isASC";
			propDesc = beanDesc.getPropertyDesc(orderProp);
			Boolean var = (Boolean) propDesc.getValue(this);
			if (!var.booleanValue()) {
				buf.append("DESC ");
			}
			ORDER = "";
			if (ite.hasNext()) {
				buf.append(",");
			}
		}
		return buf.toString();
	}

	public String toString() {
		StringBuffer buff = new StringBuffer("[");
		String order = getOrderList();
		if (!order.equals("")) {
			buff.append("/ORDER BY=").append(order);
		}
		if (getLimit() != NONE_LIMIT) {
			toString(buff, "offset", getOffset());
			toString(buff, "limit", getLimit());
		}
		
		<@toString table=table tableName=""/>
		buff.append("]");
		return buff.toString();
	}

	protected void toString(StringBuffer buf, String name, Object target) {
		if (target == null) {
			return;
		}
		buf.append("/").append(name).append("=").append(target);
	}

	protected void toString(StringBuffer buf, String name, int target) {
		buf.append("/").append(name).append("=").append(target);
	}

}
