/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.dbms;

import org.seasar.codegen.LanguageDataTypeSelectUtil;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.FieldSetting;

public abstract class AbstractDataTypeSelectUtil implements Dbms {

    protected LanguageDataTypeSelectUtil langSelectUtil;

    protected DataType getDECIMAL(FieldSetting fieldSetting) {
        String dataType = null;
        if (fieldSetting.getPointNumber() == 0) {
            if (fieldSetting.getColmnSize() == 1) {
                dataType = "boolean";
            } else if (fieldSetting.getColmnSize() <= 9) {
                dataType = "int";
            } else if (fieldSetting.getColmnSize() <= 18) {
                dataType = "long";
            } else {
                dataType = "BigInteger";
            }
        } else {
            if (fieldSetting.getColmnSize() <= 7) {
                dataType = "float";
            } else if (fieldSetting.getColmnSize() <= 15) {
                dataType = "double";
            } else {
                dataType = "BigDecimal";
            }
        }
        return getAnyDataType(fieldSetting, dataType);
    }

    protected DataType getAnyDataType(FieldSetting fieldSetting,
            String javaDataType) {
        DataType dataType = new DataType(fieldSetting);
        dataType.setLangDataType(langSelectUtil.getDataType(javaDataType,
                fieldSetting.isNotNull(), fieldSetting.getFieldDefault()));
        return dataType;
    }

    public LanguageDataTypeSelectUtil getLangSelectUtil() {
        return langSelectUtil;
    }

    public void setLangSelectUtil(LanguageDataTypeSelectUtil langSelectUtil) {
        this.langSelectUtil = langSelectUtil;
    }

}