/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.util.Map;

import org.seasar.codegen.CodeGenerator;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.OutputCode;
import org.seasar.codegen.exception.NotFileException;

public class CodeGeneratorImpl implements CodeGenerator {

    private ImportCodeData codeData;

    private OutputCode outputCode;

    public void generate(String srcData, String baseDir) {
        File src = new File(srcData);
        File base = new File(baseDir);
        if (!src.canRead()) {
            throw new NotFileException(srcData);
        }
        generate(src, base);
    }

    public void generate(File srcFile, File baseDir) {
        Map tableList = codeData.readCodeData(srcFile);
        outputCode.generateCode(baseDir, tableList);
    }

    public ImportCodeData getCodeData() {
        return codeData;
    }

    public void setCodeData(ImportCodeData codeData) {
        this.codeData = codeData;
    }

    public OutputCode getOutputCode() {
        return outputCode;
    }

    public void setOutputCode(OutputCode outputCode) {
        this.outputCode = outputCode;
    }

}
