/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.convert.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.seasar.codegen.convert.NameConverter;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.extension.unit.S2TestCase;

/**
 * 
 * @author azusa
 */
public class CamelConverterImplTest extends S2TestCase {

    private NameConverter conveter;

    public void setUp() {
        include("CamelConveterImplTest.dicon");
    }

    public void testConvert() {

        Map<String, Object> map = new HashMap<String, Object>();
        Table table = new Table();
        Field field1 = new Field();
        field1.setFieldName("FIELD_NAME1");
        Field field2 = new Field();
        field2.setFieldName("FIELD_NAME2");
        table.addTableField(field1);
        table.addTableField(field2);
        Field pkField = new Field();
        pkField.setFieldName("PRIMARY_KEY");
        PrimaryKey key = new PrimaryKey();
        key.setField(pkField);
        table.addPrimaryKey(key);
        map.put("TABLE_NAME", table);

        Table table2 = new Table();
        Field field3 = new Field();
        field3.setFieldName("FIELD_NAME3");
        Field field4 = new Field();
        field4.setFieldName("FIELD_NAME4");
        table2.addTableField(field3);
        table2.addTableField(field4);

        Table table3 = new Table();
        Field field5 = new Field();
        field5.setFieldName("FIELD_NAME5");
        Field field6 = new Field();
        field6.setFieldName("FIELD_NAME6");
        table3.addTableField(field5);
        table3.addTableField(field6);

        List<Table> list1 = new ArrayList<Table>();
        list1.add(table2);
        map.put("parentTable", list1);

        List<Table> list2 = new ArrayList<Table>();
        list2.add(table2);
        list2.add(table3);
        map.put("childTable", list2);

        conveter.convert(map);
        Table actualTable = (Table) map.get("TABLE_NAME");
        List parentTableList = (List) map.get("parentTable");
        List childTableList = (List) map.get("childTable");

        assertEquals("1", "fieldName1", actualTable
                .getTableField("FIELD_NAME1").getFieldNameForDto());
        assertEquals("2", "fieldName2", actualTable
                .getTableField("FIELD_NAME2").getFieldNameForDto());
        assertEquals("3", "primaryKey", ((PrimaryKey) actualTable
                .getPrimaryKey().get(0)).getField().getFieldNameForDto());
        assertEquals("4", "fieldName3", ((Table) (parentTableList.get(0)))
                .getTableField("FIELD_NAME3").getFieldNameForDto());
        assertEquals("5", "fieldName6", ((Table) (childTableList.get(1)))
                .getTableField("FIELD_NAME6").getFieldNameForDto());
    }

    public void testConvertFieldName() {

        CamelConverterImpl converterImpl = (CamelConverterImpl) conveter;

        assertEquals("1", "fieldName", converterImpl
                .convertFieldName("FIELD_NAME"));
        assertEquals("2", "field", converterImpl.convertFieldName("FIELD"));
        assertEquals("3", "fieldN", converterImpl.convertFieldName("FIELD_N"));
    }

    public void testConvertClassname() {
        CamelConverterImpl converterImpl = (CamelConverterImpl) conveter;

        assertEquals("1", "ClassName", converterImpl
                .convertClassName("CLASS_NAME"));
        assertEquals("2", "Class", converterImpl.convertClassName("CLASS"));
        assertEquals("3", "ClassN", converterImpl.convertClassName("CLASS_N"));
        assertEquals("4", "C", converterImpl.convertClassName("C"));
    }

}
