/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.util.Map;

import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.OutputCode;
import org.seasar.extension.unit.S2TestCase;

/**
 * 
 * @author azusa
 * 
 */
public class DDLOutputCodeImplTest extends S2TestCase {

    private String PATH = "org/seasar/codegen/impl/CreateTable.dicon";

    private ImportCodeData importCodeData;

    private OutputCode outputCode;

    public void setUpGenerateCode() throws Exception {
        include(PATH);
    }

    public void testGenerateCode() {
        File src = new File("test/codegen.csv");
        Map tableData = importCodeData.readCodeData(src);
        outputCode.generateCode(new File("testsrc"), tableData);
    }

    public void setUpGenerateCode2() throws Exception {
        include("org/seasar/codegen/impl/CreateTable_db2.dicon");
    }

    public void testGenerateCode2() {
        File src = new File("test/codegen.csv");
        Map tableData = importCodeData.readCodeData(src);
        outputCode.generateCode(new File("testsrc"), tableData);
    }

}
