package org.seasar.codegen.impl;

import java.util.List;
import java.util.Map;

import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.extension.unit.S2TestCase;

/**
 * @author azusa
 * 
 */
public class DatabaseImportCodeDataTest extends S2TestCase {

    private ImportCodeData importCodeData;

    public void setUp() {
        include("DatabaseImportCodeDataTest.dicon");
    }

    public void testReadCodeData() {

        Map map = importCodeData.readCodeData(null);

        assertNotNull("1", map);

        Table table = (Table) map.get("EMP4");
        assertEquals("2", "EMP4", table.getTableName());
        Field field = table.getTableField("ENAME");
        assertEquals("3", "ENAME", field.getFieldName());
        assertEquals("4", "VARCHAR", field.getDataType().getRdbTypeName());
        assertEquals("5", 10, field.getDataType().getColmnSize());

        field = table.getTableField("COMM");
        assertEquals("6", 7, field.getDataType().getColmnSize());
        assertEquals("7", 2, field.getDataType().getPointNumber());

        List primaryKeys = table.getPrimaryKey();
        PrimaryKey primaryKey = (PrimaryKey) primaryKeys.get(0);
        assertEquals("8", "EMPNO", primaryKey.getField().getFieldName());
        assertEquals("81", "EMPNO", primaryKey.getField()
                .getFieldAttributeName());

        LinkTable parentLink = (LinkTable) table.getParentTable().get(0);
        assertNotNull("9", parentLink);
        assertEquals("10", "DEPT4", parentLink.getTableName());

        Table parent = (Table) map.get("DEPT4");
        LinkTable childLink = (LinkTable) parent.getChildTable().get(0);
        assertEquals("11", "EMP4", childLink.getTableName());

        assertEquals("12", 2, map.keySet().size());
    }

}
