package jp.co.epson.watch.plaWasabi.converter.prmMapKey;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;

public class SimplePrmConverter implements PrmConverter {

  @SuppressWarnings("unchecked")
  @Override
  public Map<String, String[]> convert(List<Map> src) {
    if (src == null) {
      return this.convert((Map) null);
    } else if (src.size() > 1) {
      throw new WasabiRuntimeException("このコンバータは、二件以上のデータを扱えません");
    } else {
      return this.convert(src.get(0));
    }

  }

  @SuppressWarnings("unchecked")
  @Override
  public Map<String, String[]> convert(Map src) {
    Map<String, String[]> res = new HashMap<String, String[]>();

    if (src != null) {
      for (String key : ((Map<String, Object>) src).keySet()) {
        Object value = src.get(key);
        res.put(key, new String[] { value != null ? value.toString() : "" });
      }
    }

    return res;
  }

}
