package jp.co.epson.watch.plaWasabi.plugin;

import java.io.File;
import java.net.URL;

import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.apache.velocity.app.Velocity;

/**
 * Plug-In for Velocity Initialization.
 * 
 * @author K.Ono
 * 
 */
public class VelocityPlugIn implements PlugIn {
  /**
   * Commons Logging instance.
   */
  private static Log log = LogFactory.getLog(VelocityPlugIn.class);

  /**
   * Velocity property file.
   */
  private String pathname = null;

  /**
   * Sets a Velocity property file.
   *
   * @param Velocity property file path name
   */
  public void setPathname(String pathname) {
    this.pathname = pathname;  
  }

  /**
   * Initialize the Velocity.
   *
   * @throws ServletException if we cannot initialize the Velocity
   */
  public void init(ActionServlet servlet, ModuleConfig config)
  throws ServletException {
    try {
      if ((this.pathname == null) || (this.pathname.length() <= 0)) {
        throw new ServletException("No Velocity property file set.");
      }
      if (log.isInfoEnabled()) {
        log.info("Loading Velocity property file from '"
            + this.pathname + "'");
      }
      String fullpath = servlet.getServletContext().getRealPath("/") + this.pathname.replace("/", File.separator);
      if (log.isDebugEnabled()) {
        log.debug("fullpath is '"
            + fullpath + "'");
      }
      Velocity.init(fullpath);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      throw new UnavailableException(
          "Cannot initialize a Velocity resource from '" + this.pathname + "'");
    }

  }

  /**
   * Gracefully shut down, releasing any resources that were allocated at
   * initialization.
   */
  public void destroy() {
    if (log.isDebugEnabled()) {
      log.debug("Destroying VelocityPlugin");
    }	
  }

}
