package jp.co.epson.watch.plaWasabi.service;

import static jp.co.epson.watch.plaWasabi.entity.ZifileNames.zifi101;
import static org.seasar.extension.jdbc.operation.Operations.asc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;

import jp.co.epson.watch.plaWasabi.entity.Zifile;

/**
 * {@link Zifile}のサービスクラスです。
 * 
 * @author S2JDBC-Gen
 */
public class ZifileService extends AbstractService<Zifile> {

  /**
   * 識別子でエンティティを検索します。
   * 
   * @param zifi101
   *          識別子
   * @return エンティティ
   */
  public Zifile findById(String zifi101) {
    return select().id(zifi101).getSingleResult();
  }

  /**
   * 識別子の昇順ですべてのエンティティを検索します。
   * 
   * @return エンティティのリスト
   */
  public List<Zifile> findAllOrderById() {
    return select().orderBy(asc(zifi101())).getResultList();
  }

  public void persist(String calNo, String planNo, File file) throws IOException {
    byte[] fileByte = new byte[(int) file.length()];
    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
    bis.read(fileByte);

    this.persist(calNo, planNo, fileByte);
    
    bis.close();
  }

  public void persist(String calNo, String planNo, byte[] file) {

    Zifile zifile = this.findById(this.createKeyStr(calNo, planNo));
    Date sysdate = new Date();
    if (zifile == null) {
      zifile = new Zifile();
      zifile.zifi101 = this.createKeyStr(calNo, planNo);
      zifile.zifi200 = file;
      zifile.zifi888 = sysdate;
      zifile.zifi889 = sysdate;

      this.insert(zifile);

    } else {
      zifile.zifi200 = file;
      zifile.zifi889 = sysdate;

      this.update(zifile);

    }

  }

  public String createKeyStr(String calNo, String planNo) {
    String ret = calNo + "-" + planNo + ".JPG";
    return ret;
  }
}