package jp.co.epson.watch.plaWasabi.service.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;

import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelService {
  @SuppressWarnings("unchecked")
  public void createXlsBook(FieldsDef fieldsDef, List<Map> data, OutputStream os) {
    HSSFWorkbook wb = new HSSFWorkbook();
    HSSFSheet sheet = wb.createSheet("searchResult");

    int rowNum = 0;
    HSSFRow headerRow = sheet.createRow(rowNum++);
    for (int colNum : fieldsDef.getColNum()) {
      FieldDef fieldDef = fieldsDef.getField(colNum);
      headerRow.createCell(colNum).setCellValue(new HSSFRichTextString(fieldDef.name));
    }

    for (Map<String, Object> rowData : data) {
      HSSFRow row = sheet.createRow(rowNum++);
      for (int colNum : fieldsDef.getColNum()) {
        FieldDef fieldDef = fieldsDef.getField(colNum);
        Object cellData = rowData.get(fieldDef.id);
        if (cellData != null) {
          row.createCell(colNum).setCellValue(new HSSFRichTextString(cellData.toString()));
        }
      }
    }

    try {

      wb.write(os);

    } catch (IOException e) {
      throw new WasabiRuntimeException(e);
    }

  }

}
