/**
 * 
 * StraformX
 * TableAction(テーブルの行追加/削除)APIを利用するサンプル
 * 
 */
package jp.co.epson.watch.plaWasabi.stxsample;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.fit.stx.servercomponent.core.HtmlTableAction;
import jp.co.fit.stx.servercomponent.core.HtmlTableActionIF;

public class TableActionSample extends HttpServlet {
  private static final long serialVersionUID = 3949946872055584866L;
  private String currentDir = "";
  private String htmlFile = "gijiroku_i.htm";

  protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,
      IOException {
    // 文字コードのセット
    req.setCharacterEncoding("MS932");

    // ベースディレクトリをセット
    ServletContext sc = getServletConfig().getServletContext();
    currentDir = sc.getRealPath("/") + "stxsample" + File.separator;

    // 結果出力をresponseに設定して、行操作を呼ｄ双し
    tableactionSample(req, res.getOutputStream());
  }

  @SuppressWarnings("unchecked")
  private void tableactionSample(HttpServletRequest req, OutputStream out) {
    FileInputStream html = null;
    try {
      /**
       * //サーバーから固定的に行操作を行う場合は、以下のようなキーと値およびpostされた値をHashMapにセットします // 行追姥pパラメータ
       * params.put("TABLE_ID","Table2");
       * params.put("TABLE_FUNCTION",HtmlTableAction.ROW_INSERT_AFTER);
       * params.put("BTN_NAME","TextField24_R_2"); params.put("COUNT","1");
       **/

      // テンプレートHTMLをセット
      html = new FileInputStream(currentDir + htmlFile);

      // APIを呼ｄ双し
      HtmlTableActionIF ha = new HtmlTableAction();
      int rv = ha.tableAction((HashMap) req.getParameterMap(), HtmlTableActionIF.IMPORT_FOR_INPUT,
          html, out);

      if (rv == 0) {
        System.out.println("HtmlTableAction OK.");
      }
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      if (html != null)
        try {
          html.close();
        } catch (IOException e) {
          e.printStackTrace();
        }

    }
  }
}
