/**
 * 
 * StraformX
 * XmlExporter(入力値をXMLに保存する)APIを利用するサンプル
 *
 */

package jp.co.epson.watch.plaWasabi.stxsample;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.fit.stx.servercomponent.core.XmlExporter;
import jp.co.fit.stx.servercomponent.core.XmlExporterIF;

public class XmlExporterSample extends HttpServlet {
  private static final long serialVersionUID = -8070127502992387010L;
  private String currentDir = "";
  private String xslFile = "gijiroku.xsl";
  private String dtdUrl = "./stxsample/gijiroku.dtd";

  protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,
      IOException {
    // 文字コードのセット
    req.setCharacterEncoding("MS932");

    // ベースディレクトリをセット
    ServletContext sc = getServletConfig().getServletContext();
    currentDir = sc.getRealPath("/") + "stxsample" + File.separator;

    // 結果出力をresponseに設定して、XML変換を呼ｄ双し
    xmlexportTest(req, res.getOutputStream());
  }

  /**
   * XSLとDTDをもとにXMLを生成する
   * 
   * @param out
   * @throws IOException
   */
  @SuppressWarnings("unchecked")
  private void xmlexportTest(HttpServletRequest req, OutputStream out) {
    FileInputStream[] xsls = null;
    try {
      // xslとdtdをセット
      xsls = new FileInputStream[] { new FileInputStream(currentDir + xslFile) };
      String[] dtds = new String[] { dtdUrl };

      XmlExporterIF xe = new XmlExporter();
//      int rv[] = xe.exporter((HashMap) req.getParameterMap(), xsls, dtds,
//          new OutputStream[] { out });
//
//      if (rv[0] == 0) {
//        System.out.println("XML Exporter OK.");
//      }
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      try {
        if (xsls != null) {
          for (int i = 0; i < xsls.length; i++) {
            xsls[i].close();
          }
        }
        out.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
  }
}
