package jp.co.epson.watch.plaWasabi.test.service;

import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;

import jp.co.epson.watch.plaWasabi.service.ChangeLogService;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.extension.unit.S2TestCase;

public class ChangeLogServiceTest extends S2TestCase {

  @Resource
  private JdbcManager jdbcManager;

  @Resource
  private ChangeLogService changeLogService;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    include("app.dicon");
  }

  public void testAvailable() throws Exception {
    assertNotNull(changeLogService);
  }

  @SuppressWarnings("unchecked")
  public void testGetLogs() {
    String changeLogSql = this.createChangeLogStatement();
    List<HashMap> changeLogMap = this.jdbcManager.selectBySql(HashMap.class, changeLogSql,
        "plan-mod", "104").getResultList();

    System.out.println(changeLogMap);
  }

  private String createChangeLogStatement() {
    StringBuilder sql = new StringBuilder();

    sql.append("select ");
    sql.append("    T1_.USER_ID , ");
    sql.append("    to_char(T1_.CHANGE_TIME ,'RRRR/MM/DD HH24:MI:SS') as CHANGE_TIME ,");
    sql.append("    T1_.UPDATED_CONTENT ");
    sql.append("from CHANGE_LOG T1_ ");
    sql.append("where T1_.APL_CD = ? ");
    sql.append("and   T1_.APL_SEQ = ? ");
    sql.append("order by T1_.SEQ desc ");

    return sql.toString();
  }

}