//##CLASS////////////////////////////////////////////////////////////
//Programming		:	Satoshi Fujiwara.
//Project Name	:	GENX
//File			:	GDSoundEffect.cpp
//Content 		:	TEhNX
//HeaderFile	:	GDSoundeffect.h
//##CLASS_END/////////////////////////////////////////////////////////

#include "GDSoundEffect.h"

GDSoundEffect::GDSoundEffect(){
	int i;
	
	for(i = 0;i < WAVEDATA_MAX;i++){
		pWaveData[i] = NULL;
	
	}

	for(i = 0;i < SOUNDBUFFER_MAX;i++){
		pSoundBuffer[i] = NULL;
	}
	effectcount = 0; 
	fWaveLoad = FALSE;
	if(isSoundSupport())
		bEffect = TRUE;
	else
		bEffect = FALSE;
	serial = 0;
}

GDSoundEffect::~GDSoundEffect(){
	Release();

}
void GDSoundEffect::Release(void){
	int i;
	DWORD dwStatus;

	for(i = 0;i < WAVEDATA_MAX;i++){
		if(pWaveData[i]){
			pWaveData[i]->GetStatus(&dwStatus);
			if(dwStatus & DSBSTATUS_PLAYING)
				pWaveData[i]->Stop();
			pWaveData[i]->Release();
			pWaveData[i] = NULL;
		}
	}

	for(i = 0;i < SOUNDBUFFER_MAX;i++){
		if(pSoundBuffer[i]){
			pSoundBuffer[i]->GetStatus(&dwStatus);
			if(dwStatus & DSBSTATUS_PLAYING)
				pSoundBuffer[i]->Stop();
			pSoundBuffer[i]->Release();
			pSoundBuffer[i] = NULL;
		}
	}
	effectcount = 0;
}

BOOL GDSoundEffect::Load(char * szFileName){
 	if(!isSoundSupport()) return FALSE;
	FILE *fp;
	if(isLoad())
		Release();
	if((fp = fopen(szFileName,"rb")) == NULL){
		return FALSE;
	}
	while ((fscanf(fp,"%s",&WavFileName[effectcount][0]) != EOF) && (effectcount < WAVEDATA_MAX)){
		pWaveData[effectcount] = DSLoadSoundBuffer(lpDS,&WavFileName[effectcount][0]);
		effectcount ++;
	}
	fclose(fp);
	fWaveLoad = TRUE;
	return TRUE;
}

void GDSoundEffect::Play(int SoundBufferNumber,long volume,long pan)
{
	DWORD dwStatus = 0;
	DWORD dsrval;
	int wold = 0;
	int woldindex = 0;
	int i = 0;
	
	if(!isSoundSupport()) return;
	if(!bEffect) return;

	if(SoundBufferNumber > effectcount || !pWaveData[SoundBufferNumber])
		return;
	
	pWaveData[SoundBufferNumber]->GetStatus(&dwStatus);

	if(dwStatus & DSBSTATUS_BUFFERLOST){
		pWaveData[SoundBufferNumber]->Restore();
		if(DSReloadSoundBuffer(pWaveData[SoundBufferNumber],&WavFileName[SoundBufferNumber][0]) == FALSE)
			return;

	}

	for(i = 0;i < SOUNDBUFFER_MAX;i++){
		if(!pSoundBuffer[i]){//Sound Buffer  NULLigpj̏ꍇ
			dsrval = lpDS->DuplicateSoundBuffer(pWaveData[SoundBufferNumber],&pSoundBuffer[i]);
			if(dsrval != DS_OK){
				return;
			}
			pSoundBuffer[i]->SetVolume(volume);
			pSoundBuffer[i]->SetPan(pan);
			pSoundBuffer[i]->Play(0,0,0);
			usecount[i] =  GetSerial();
			return;
		} else {//Sound BuffergpĂꍇ
			pSoundBuffer[i]->GetStatus(&dwStatus);
			if(!(dwStatus & DSBSTATUS_PLAYING) || (dwStatus & DSBSTATUS_BUFFERLOST)){
				if(dwStatus & DSBSTATUS_BUFFERLOST)
					pSoundBuffer[i]->Restore();
				pSoundBuffer[i]->Release();
				dsrval = lpDS->DuplicateSoundBuffer(pWaveData[SoundBufferNumber],&pSoundBuffer[i]);
				pSoundBuffer[i]->SetVolume(volume);
				pSoundBuffer[i]->SetPan(pan);
				pSoundBuffer[i]->Play(0,0,0);
				usecount[i] = GetSerial();
				return;
			}
			if(!wold){
				wold = usecount[i];
				woldindex = i;
			} else {
				if(wold > usecount[i]){
					wold = usecount[i];
					woldindex = i;
				}
			}
		}
	}
	//ꍇ́ASound Buffer ̋󂫂ȂƂɂȂ
	pSoundBuffer[woldindex]->Stop();
	pSoundBuffer[woldindex]->Release();
	dsrval = lpDS->DuplicateSoundBuffer(pWaveData[SoundBufferNumber],&pSoundBuffer[woldindex]);
	pSoundBuffer[woldindex]->SetVolume(volume);
	pSoundBuffer[woldindex]->SetPan(pan);
	pSoundBuffer[woldindex]->Play(0,0,0);
	usecount[woldindex] = GetSerial();

}

