// dmplayer.h : header file
//
// Copyright (c) 1998 Microsoft Corporation. All rights reserved.
/////////////////////////////////////////////////////////////////////////////
#ifndef _DMPLAYER_H
#define _DMPLAYER_H
#include <windows.h>
#include <objbase.h>
//#include <initguid.h>
#include <direct.h>
#include <dmusicc.h>
#include <dmusici.h>
#include "events.h"
#include "events.h"

#define NUM_SCHEMES			1
#define NUM_TEMPLATES		5

// The scheme structure stores all of the filename and motif names associated with
// a musical scheme.
struct SCHEME
{
	PWSTR FriendlySchemeName;				//Human readable name for the menu
	PWSTR StyleName;						//Filename
	PWSTR DLSName;							//Filename (blank if the style uses GM.DLS)
	PWSTR ChordMapName;						//Filename
	PWSTR TemplateNames[NUM_TEMPLATES];		//Filename
	PWSTR MotifNames[DME_MAXEVENTNUM];		//Motif name contained in the style (referenced above)
};

#define MENU_FIELD_LENGTH	256
#define ITEM_LENGTH			128
#define INVALID_PORT		0
#define VALID_PORT			1
#define SELECTED_PORT		2
#define NO_PORT		        3

/////////////////////////////////////////////////////////////////////////////
//  The DMPlayer class encapsulates all of the DirectMusic interface and objects.
//  CMain calls DMPlayer to respond to incoming Shell events and user input
//  from the popup menu.
//

class CDMPlayer
{
public:
	CDMPlayer(HWND hWnd);
	virtual ~CDMPlayer();
	BOOL SelectNewScheme(WORD wSchemeNum);
	BOOL SelectOutputPort(WORD wPortIndex);
	BOOL GetSchemeName(WORD wSchemeNum, PWSTR pwzSchemeName, WORD wBufferLength);
	WORD EnumOutputPort(WORD wPortIndex, PWSTR pwzPortName, WORD wBufferLength);
	void Start();
	void Stop();
	BOOL IsPlaying();
	BOOL IsInitialized(void){return m_bIsInitialized;};
	void PlayMotif(WORD wMotif);
	void PlaySegment(void);
	void StopSegment(void);
	void SelectTemplateNum(WORD wTemplateNum);
	WORD GetTemplateNum(void){return m_wTemplateNum;}; 
protected:
	void ResetMidiStream();
	void NullMediaPointers();
	void ReleaseMediaPointers();
	BOOL InitializeSynth();
	BOOL LoadScheme(WORD wSchemeIndex);
	BOOL LoadStyle(WCHAR* pwzFileName);
	BOOL LoadDLS(WCHAR* pwzFileName);
	BOOL LoadChordMap(WCHAR* pwzFileName);
	BOOL LoadTemplate(DWORD dwIndex, WCHAR* pwzName);
	BOOL ComposeSegment(DWORD dwIndex);

	IDirectMusicLoader*			m_pLoader;
	IDirectMusicPerformance*	m_pPerformance;
	IDirectMusicStyle*			m_pStyle;
	IDirectMusicSegment*		m_pMotifs[DME_MAXEVENTNUM];
	IDirectMusicChordMap*	    m_pChordMap;
	IDirectMusicSegment*		m_pTemplates[NUM_TEMPLATES];
	IDirectMusicSegment*		m_pPrimarySegments[NUM_TEMPLATES];
								// the primary segments correspond to the templates
								// on a 1:1 basis
	IDirectMusicComposer*		m_pComposer;
	IDirectMusic*				m_pDirectMusic;
	IDirectMusicPort*			m_pPort;
	IDirectMusicBand*			m_pBand;

	HWND m_hWnd;
	BOOL m_bIsPlaying;
	BOOL m_bIsInitialized;
	MUSIC_TIME m_mtPreviousEventBeatNumber[DME_MAXEVENTRANGE];
	WORD m_wTemplateNum;
};

#endif // _DMPLAYER_H

/////////////////////////////////////////////////////////////////////////////






