//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// MyBullets.cpp: MyBullets NX̃Cve[V
//	F
// $Log: MyBullets.cpp,v $
// Revision 1.1  2001/10/28 21:40:36  fujiwara
// DLLɕ
//
// Revision 1.8  2001/07/09 20:30:09  fujiwara
// Ȏgݍ
//
// Revision 1.7  2001/07/01 21:30:34  fujiwara
// [N`FbN
//
// Revision 1.6  2001/07/01 01:03:44  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.5  2001/06/10 21:17:01  fujiwara
// ^[Qbgǉinpj
//
// Revision 1.4  2001/05/29 01:12:35  fujiwara
// GL(sj̍쐬BzuGfB^̃oOC
//
// Revision 1.3  2001/05/13 20:04:24  fujiwara
// [[N̂Ŏ菜B
// ẽTEheXg
//
// Revision 1.2  2001/05/12 00:49:34  fujiwara
// bur𓱓AO\ǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
///////////////////////////////////////////////////////////////////////////////
#pragma warning( disable : 4786 )	//STĽxO

// [[Nop
#include "sfdebug.h"

#include <string>
#include <vector>
#include <memory>
#include <stack>
#include <list>
#include <iostream>
#include <fstream>
#include <map>

#include "stdio.h"
#include "math.h"

#include "exception.h"
#include "singleton.h"
#include "system.h"
#include "console.h"
#include "input.h"
#include "sound.h"

#include "Obj.h"
#include "Obj2D.h"
#include "Obj3D.h"
#include "Obj3DL.h"
#include "ObjRectangle.h"
#include "ObjQuadrangle.h"

#include "Background.h"
#include "Scene.h"
#include "main.h"

#include "character.h"
#include "Hit.h"
#include "MyShip.h"
#include "Game.h"
#include "Enemys.h"
#include "Armys.h"
#include "DispositionControl.h"
#include "AbstractCharacter.h"
#include "MyBullets.h"

using namespace sf::application;
using namespace sf::system::console;
using namespace sf::application::player::bullet;

//////////////////////////////////////////////////////////////////////
// Bullets 
//////////////////////////////////////////////////////////////////////

const int Bullets::INIT_BULLETS = 3;

// IuWFNg\bhւ̃|C^ 
const Bullets::CreateFuncPtr Bullets::mpFunctions[MAX_TYPE] = {
	&Normal::create
};

// eNX`[_[ւ̃|C^
const Bullets::LoaderFuncPtr Bullets::mpLoaders[MAX_TYPE] = {
	&Normal::load
};

int Normal::mSoundID = 0;
int Normal::mSoundIDB = 0;

// VOgp^[[܂邽߂̃}N
IMPLEMENT_SINGLETON(Bullets,Bullets)

// RXgN^ |||||||||||||||||||||||||||||
Bullets::Bullets()
{
	int i;
	for(i = 0;i < MAX_BULLETS;i++){
		mpBullets[i] = NULL;
	}

	mMax = INIT_BULLETS;
	mCount = 0;
}// Bullets()

// fXgN^ ||||||||||||||||||||||||||||||
Bullets::~Bullets()
{
	int i;

	for(i = 0;i < MAX_BULLETS;i++)
	{
		if(mpBullets[i]){
			delete mpBullets[i];
			mpBullets[i] = NULL;
		}
	}


}// ~Bullets()

//  |||||||||||||||||||||||||||||||||
void Bullets::initialize(){
	
	int i;
	for(i = 0;i < MAX_BULLETS;i++)
	{
		if(mpBullets[i]){
			delete mpBullets[i];
			mpBullets[i] = NULL;
		}
	}

	// rbg}bṽ[h
	for(i = 0;i < MAX_TYPE;i++){
		(*mpLoaders[i])();
	}
	mCount = 0;
}// initialize()

// ëړ ||||||||||||||||||||||||||||||||
void Bullets::move(void)
{
	int count = 0;
	for(int i = 0;i < MAX_BULLETS;i++)
	{
		if(mpBullets[i]){
			mpBullets[i]->move();
		}
	}
}// move()

// e𐶐 ||||||||||||||||||||||||||||||
const bool Bullets::create(const TYPE id,const float x,const float y,const float z,sf::application::scene::Game * const pGame)
{
	if(id >= MAX_TYPE)
		return false;

	if(mCount >= mMax)
		return false;
	
	for(int i = 0 ; i < MAX_BULLETS; i++){
		if(mpBullets[i] == NULL){
			mpBullets[i] = (*mpFunctions[id])(x,y,z,pGame,i);
			mCount++;
			return true;
		}
	}
	return false;
}// create()

// 蔻 ||||||||||||||||||||||||||||||||
const bool Bullets::hitCheck(Character * const pDest){
	bool return_ = false;

	for(int i = 0;i < MAX_BULLETS;i++){
		if(mpBullets[i]){
			if(mpBullets[i]->hitCheck(pDest)){
				mpBullets[i]->hit(pDest);
				pDest->hit(mpBullets[i]);
				return_ = true;
			};
		}
	}
	return return_;
}// hitCheck(Character * const pDest)

const bool Bullets::hitCheck(Characters * const pDest){
	bool return_ = false;

	for(int i = 0;i < MAX_BULLETS;i++){
		if(mpBullets[i]){
			if(pDest->hitCheck(mpBullets[i]))
				return_ = true;
		}
	}

	return return_;
}// hitCheck(Characters * const pDest)


// |||||||||||||||||||||||||||||||||||||
// m[}e
// |||||||||||||||||||||||||||||||||||||

const console::sprite::Info Normal::mSpriteInfo = {
	"media\\normal.png",0.0f,0.0f,0.0f,0.0f,0xff000000,console::sprite::SPRITE2D
};

const console::sprite::Info Normal::mSpriteBInfo = {
	"media\\normalb.png",0.0f,0.0f,32.0f,32.0f,0xff000000,console::sprite::SPRITE2D
};

const float Normal::mTextureHeight = 32.0f;
const float Normal::mTextureWidth = 32.0f;

std::auto_ptr<sf::system::console::sprite::Sprite> Normal::mpSprite;
std::auto_ptr<sf::system::console::sprite::Sprite> Normal::mpSpriteB;

//  |||||||||||||||||||||||||||||||||
void Normal::initialize()
{
	mHitRect.offsetTop(-8.0f);
	mHitRect.offsetLeft(-2.0f);
	mHitRect.offsetBottom(8.0f);
	mHitRect.offsetRight(2.0f);
	mHitRect.isChecking(true);
	mHitRect.characterPtr(this);
	mbHit = false;
	mObj.x(x());
	mObj.y(y());
	mObj.z(z() + Z_OFFSET);
	mObj.color(0xc0ffffff);
	mObj.drawMode(DRAW_ADD);

	mObj.sprite(mpSprite.get());
	mObj.visibility(true);
	
	speed(-48.0f * sf::system::instance()->deltaTime());
	direction(sf::system::PI / 2.0f);
	mObj.angle(direction());
	mBeforeY = y();
	sf::system::instance()->sound()->play(mSoundID,1,false,false);
	life(1);
	mState = MOVE;
}// Normal::initialize

// e̓ ||||||||||||||||||||||||||||||||
void Normal::move(void){
	
	switch(mState)
	{
	case MOVE:
		mBeforeY = y();
		y(y() + speed());
		mObj.y(y());
	
		if(y() < (viewport::Y - mTextureHeight / 2.0f)){
			delete this;
			return;
		}
		// 蔻̕␳ 
		mHitRect.offsetBottom(mHitRect.offsetTop() - speed() );
		break;
	case BOUND:
		mAnimCount++;
		if(mAnimCount > 7.0f){
			mState = DEAD;
			break;
		}
		mObj.index(mAnimCount);
		break;
	case DEAD:
		delete this;
		return;
	}
}// Normal::move()

// eNX`ETEh̃[h |||||||||||||||||||||||||||
void Normal::load(void){
	using namespace sf::system::console::sprite;
	if(!mpSprite.get()){
		std::auto_ptr<sf::system::console::sprite::Sprite> ptemp(sf::system::instance()->console()->createSprite(&mSpriteInfo)); 
		mpSprite = ptemp;
		std::auto_ptr<sf::system::console::sprite::Sprite> ptemp1(sf::system::instance()->console()->createSprite(&mSpriteBInfo)); 
		mpSpriteB = ptemp1;
	}
	using namespace sf::system;
	mSoundID = instance()->sound()->load("beam.wav");
	mSoundIDB = instance()->sound()->load("bound.wav");

}// Normal::load()

Character * const Normal::create(float x,float y ,float z,sf::application::scene::Game * const pGame,int index)
{
	Normal * ptemp = new Normal;
	ptemp->x(x);
	ptemp->y(y);
	ptemp->z(z);
	ptemp->index(index);
	ptemp->game(pGame);
	ptemp->initialize();
	return ptemp;
};// create()
