/**
 * @file
 * @brief V[C^[tF[XAт̊֘A`s.
 * 
 * @author S.F.
 * @version $Id:
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#ifndef SCENE_H
#define SCENE_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "singleton.h"
#include "sfinterface.h"
#include "scenetype.h"
namespace sf {
	namespace application {
		/// V[Ɋ֘Âׂ͂Ă̖OԂɊ܂܂܂B
		namespace scene{

			class Scene;
			class Listener;

			/** V[C^[tF[X.
			 * V[Ƃ́ÃQ[ł̓X^[gʁAQ[ʁA^CgʁDDDȂǂ̂Ƃw܂B
			 * V[؂ւɍsgWVP̃V[ƂĂƂ炦Ă܂B
			 */
			class SF_INTERFACE Scene 
			{
			public:
				/// RXgN^
				Scene() {};
				/// fXgN^
				virtual ~Scene() {};
				// OPERATORS //
				// OPERATIONS //
				/// V[s
				virtual void move(void) = 0;
				/** V[sCxg󂯎ListenerC^[tF[Xo^ 
				 * @param Listener ̃|C^ */
				virtual void addListener(Listener * const pListener) = 0;

				/** V[sCxg󂯎ListenerC^[tF[X폜 
				 * @param Listener ̃|C^ */
				virtual void removeListener(Listener * const pListener) = 0;
				/** V[x~ */
				virtual void sleep(void) = 0;
				/** V[ANeBuɂ */
				virtual void active(void) = 0;
				// ACCESS //
				/** V[̎ނ擾
				 * @return scent::Type */
				virtual const scene::TYPE  type() const = 0;
				// INQUIRY //
				/** V[̏Ԃ擾
				 @retval true  
				 @retval false x~ */
				virtual const bool  isActive(void) const = 0;
			};// Scene()

			/** Scene𐶐郁\bh */
			typedef Scene *(*CreateSceneMethod)(int);
	
		
			/** CxgXi[C^tF[X */
			class SF_INTERFACE Listener 
			{
			public:
				/**  V[I 
				 @param pScene Scene C^[tF[X̃|C^ */
				virtual void endOfScene(Scene * const pScene) = 0;
				/**  ExitKeyꂽ
				 @param pScene Scene C^[tF[X̃|C^ */
				virtual void exitKeyPressed(Scene * const pScene) = 0;
			};// Listener

		}// scene
	}// application
}// sf

#endif