//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// GameImpl.h: GameImpl NX̃C^[tFCX
//	F
// $Log: GameImpl.h,v $
// Revision 1.1  2001/10/28 21:40:36  fujiwara
// DLLɕ
//
// Revision 1.11  2001/07/09 20:30:08  fujiwara
// Ȏgݍ
//
// Revision 1.10  2001/07/01 01:03:44  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.9  2001/06/10 21:17:54  fujiwara
// npǉ
//
// Revision 1.8  2001/06/03 09:22:32  fujiwara
// nGNXюGG̔
//
// Revision 1.7  2001/05/29 01:12:54  fujiwara
// GL(sj̍쐬BzuGfB^̃oOC
//
// Revision 1.6  2001/05/17 12:34:10  fujiwara
// nGTv쐬
//
// Revision 1.5  2001/05/13 20:04:24  fujiwara
// [[N̂Ŏ菜B
// ẽTEheXg
//
// Revision 1.4  2001/05/12 12:48:28  fujiwara
// zuGfB^쐬ɔύXEǉ
//
// Revision 1.3  2001/05/12 00:50:33  fujiwara
// bur𓱓AO\ǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_GAME_H__41F747F0_5498_488A_AE73_BC66B991D0ED__INCLUDED_)
#define AFX_GAME_H__41F747F0_5498_488A_AE73_BC66B991D0ED__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AbstractScene.h"
#include "Game.h"

namespace sf {
	namespace application {
		
		namespace disposition {
			class Controller;
		}
		
		namespace player {
			namespace bullet{
				class Bullets;
				class GroundBullets;
			}
		}
		
		namespace enemy {
			class Enemys;
			class Bullets;
			class Armys;
		};

		namespace effect {
			class Effects;
		};

		namespace scene {


class GameImpl : public AbstractScene,public sf::system::input::keyboard::Listener,public Game
{
public:
	// LIFECYCLE //
	
	GameImpl();
	virtual ~GameImpl();
	
	// OPERATOR //
	
	// OPERATIONS //

	// ړ
	void move(void);
	
	// V[ICxg
	void endOfScene(Scene * const pScene);
	// IL[Cxg
	void exitKeyPressed(Scene * const pScene);
	// L[Cxg 
	void keyDown(const DWORD keyCode,const DWORD extKeyCode);
	// L[AbvCxg
	void keyUp(const DWORD keyCode,const DWORD extKeyCode){};
	// L[{[hCxgM邩
	const bool isListeningKeyboard(void) const {return mbKeyboardListening;};
	// InputfoCXŃCxg
	void keyboardTalkerIsDeleted(void){mpInput = NULL;};
	// vC[\
	void printPlayerInfo();
	// f[^GfBbg\
	void printEditInfo();
	// Q[f[^[h
	void load(const char * const pFileName);

	// ACCESS //
	const TYPE type() const{return GAME;};
		
	// wi //
	sf::system::console::Background* const background(void){return &mBackground;};
	
	// @ //
	sf::application::Character * const player(void){return mpMyShip;};
	
	// Փx 
	const DIFFICULTY difficulty(void) const { return mDifficulty;};
	void difficulty(const DIFFICULTY value);
	
	// ݂̓Փx
	const float currentDifficulty(void) const {return mCurrentDifficulty;};
	void currentDifficulty(float value)
	{	if(value > (float)HARD)
			mCurrentDifficulty = (float)HARD;
		else
			mCurrentDifficulty = value;
	};

	// Xe[W No 
	void stageNo(const int value)
	{	int tmp = value;
		if(value < 0) tmp = 0;
		if(value > mStageMax ) tmp = mStageMax;
		mStageNo = tmp;
	};
	const int stageNo() const {return mStageNo;};
	
	// XN[x 
	void scrollSpeed(const float value){mScrollSpeed = value * sf::system::instance()->deltaTime();};
	const float scrollSpeed(void) const {return mScrollSpeed;}; 
	
	// XRA
	void score(const int value){mScore = value;};
	const int score(void) const {return mScore;};
	
	// XN[Y ʒu 
	void scrollY(const float value){
		mBackground.offsetY(value);
		mScrollY = mBackground.offsetY();};
	const float scrollY(void) const {return mScrollY;};
	
	// X^[gʒu̐ݒ 
	void restartPosition(const float value){mRestartPosition = value;};
	const float restartPosition(void) const {return mRestartPosition;};

	// zuf[^IuWFNg 
	sf::application::disposition::Controller* const controllerPtr(void) 
	{ return mpController;};

	//  
	void state(const STATE value){mState = value;};
	const STATE state(void) const {return mState;};

	// ^C}
	const int timer (void) const {return mTimer;};
	
	// INQUIRY 

private:

	void main();
	void initialize();
	void resetObjects();
	void loadStageData();
	void over();
	void clear();
	void restart();

	int mTimer;
	STATE mState;


	bool mbKeyboardListening;
	
	player::Ship* mpMyShip;
	player::bullet::Bullets *mpBullets;
	player::bullet::GroundBullets *mpGroundBullets;
	enemy::Enemys *mpEnemys;
	enemy::Bullets *mpEnemyBullets;
	enemy::Armys *mpArmys;
	Scene * mpStart;
	effect::Effects *mpEffects;

	sf::system::console::Background mBackground;
	sf::application::disposition::Controller* mpController;
	
	float mScrollY;
	float mScrollSpeed;
	float mRestartPosition;
	bool mbEdit;

	DIFFICULTY mDifficulty;
	float mCurrentDifficulty;
	int mStageNo;
	int mScore;
	int mStageMax;
	int mBgmId;

	std::vector<Data> mStageData;
};
		}
	}
}

#endif // !defined(AFX_GAME_H__41F747F0_5498_488A_AE73_BC66B991D0ED__INCLUDED_)
