/**
 * @file
 * @brief wi`搧֘A̎s.
 * 
 * @author S.F.
 * @version $Id:
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#if !defined(AFX_Background_H__78BD459C_E52C_4BE9_B8DB_8A6DDAFE1E52__INCLUDED_)
#define AFX_Background_H__78BD459C_E52C_4BE9_B8DB_8A6DDAFE1E52__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h"
extern "C" {
namespace sf {
	namespace system {
		namespace console {


/** wi`搧s.
 * wi̕`s܂B
 * wíA64~64pixel̃rbg}bv~l߂邱ƂŎĂ܂B
 * wiʂ̐݌v<a href="../../images/2001031102.gif">̐}</a>QƂ*/
class Background : public ObjRectangle 
{
public:
	///XvCgeNX`Xgz^̒`
	typedef std::vector<sprite::Sprite *> TextureList;
	///XvCgeNX`񃊃Xgz^̒`
	typedef std::vector<sprite::Info> TextureInfoList;
	///}bvf[^^̒`
	typedef std::vector<int> MapData;

	/// RXgN^
	Background();
	/// fXgN^
	virtual ~Background();
	/// wi`s
	virtual void draw();
	// ACCESS //

	/** ݂̉ʂɑ΂ItZbgwWQƂ 
	 * @return ItZbgX */
	const float offsetX() const {return mOffsetX;};
	
	/** ݂̉ʂɑ΂ItZbgwWݒ肷 
	 * @param value ItZbgX */
	void offsetX(const float value){mOffsetX = value;};
	 
	/** ݂̉ʂɑ΂ItZbgxWQƂ 
	 * @return ItZbgxW */
	const float offsetY() const {return mOffsetY;};
	
	/** ݂̉ʂɑ΂ItZbgxWݒ肷 
	 * @param value ItZbgxW */
	void offsetY(const float value)
	{
		if(value < mOffsetYLimit) mOffsetY = value ;else mOffsetY = mOffsetYLimit;
		if(mOffsetY < 0.0f) mOffsetY = 0.0f;
	};
	
	/** ۑĂf[^ׂĔj */
	void unload();
	
	/** }bvf[^[h 
	 * @param pMapFileName }bvt@CPATH */
	void load(const char * const pMapFileName);

	/** XN[Ƀ}bvf[^Zbg 
	 * @param screenX XN[XW 
	 * @param screenY XN[YW
	 * @param value rbg}bvf[^̃CfbNX */
	void setData(float screenX,float screenY,DWORD value);
	
	/** }bvf[^ۑ 
	 * @param pFileName ۑ̃}bvt@CPATH 
	 * @retval true 
	 * @retval false s */
	bool save(const char *pFileName);

	/** XvCgeNX`XgzQƂ 
	 * @return TextureList̃|C^ */
	TextureList* textureList(void){ return &mTextureList;};

	/** }bv֘A̒萔`NX.
	 * OԂɂ̂łABackground̒̒`Ƃ`ɂʂ̂悤ȂƂ...*/
	class SFDLL Map {
	public:
		static const int WIDTH;///< Map̕
		static const int HEIGHT_MAX;///< Map̍ő咷
		static const int CELL_SIZE;///< Z̃TCY
		static const int CELL_TEX_COUNT_W;///< ʉ̃}bvZ̐
		static const int CELL_TEX_COUNT_H;///< ʏc̃}bvZ̐

		static const int DRAW_HEIGHT;///< `cTCY
		static const float DRAW_START_X;///< `JnX
		static const float DRAW_START_Y;///< `JnY
		static const float DRAW_CENTER_Y;///< `撆SYW
	};
	
	/** `JnItZbgX擾 
	 * @return `JnItZbgX */
	const float startOffsetX(void) const {return mbEdit ? mStartOffsetX : 0.0f;};

	/** `JnItZbgXZbg 
	 * @param value  `JnItZbgX */
	void startOffsetX(const float value){mStartOffsetX = value;};
	
	/** `JnItZbgYW擾 
	 * @return `JnItZbgYW */
	const float startOffsetY(void) const {return mbEdit ? mStartOffsetY : 0.0f;};
	
	/** `JnItZbgYZbg 
	 * @param value  `JnItZbgY */
	void startOffsetY(const float value){mStartOffsetY = value;};
	
	/** ҏWǂ
	 * @return true ҏW false ҏWłȂ */
	const bool edit(void)  const {return mbEdit;};
	
	/** ҏWǂݒ肷
	 * @param value true ҏW false ҏWłȂ */
	void edit(const bool value){mbEdit = value;};

private:
	int mMapWidth,///< Map̕
		mMapHeight;///< Map̍
	float mOffsetYLimit;///< ItZbgY̌x
	float mOffsetX,///< ItZbgX
		  mOffsetY;///< ItZbgY
	
	float mStartOffsetX,///< `JnItZbgX
	mStartOffsetY;///< `JnItZbgY
	
	bool mbEdit;///< ҏWǂ
	int *mpMap;/// Map݈̌ʒu
	MapData mMapData;///< MapData
	TextureList mTextureList;///< XvCgeNX`z
	TextureInfoList mTextureInfoList;///< XvCgeNX`z
	Console *mpConsole;///< ConsoleC^[tF[X̃|C^
	std::string mFileName;///< MapPATH
	sf::system::console::sprite::Sprite * mpBlankSprite;///< 󔒂̃XvCg
	sf::system::console::ObjQuadrangle mObj[2];///< ҏW̔\̈\邽߂ObjQuadranglez
	static const sf::system::console::sprite::Info Background::msBlankSpriteInfo;///< 󔒃XvCg
};
		}
	}
}
}
#endif // !defined(AFX_Background_H__78BD459C_E52C_4BE9_B8DB_8A6DDAFE1E52__INCLUDED_)
