/**
 * @file
 * @brief ʕ`iXvCgEwi摜j̎s.
 *
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#if !defined(AFX_ConsoleImpl_H__B6F6F87A_C87F_40DA_8F4F_C037111CAC9D__INCLUDED_)
#define AFX_ConsoleImpl_H__B6F6F87A_C87F_40DA_8F4F_C037111CAC9D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h"
#include "Console.h"
extern "C" {
namespace sf { 
	namespace system {
		namespace console {
			/// XvCgp o[ebNXobt@̃tO 
			const DWORD VertexFVF = 
				(D3DFVF_XYZRHW | ///< Wn
				D3DFVF_DIFFUSE | ///< fBt[Y
				D3DFVF_SPECULAR	| ///< XyL
				D3DFVF_TEX1 );

			/// 3DJX^_tH[}bg
			struct Vertex2 {
			    D3DVECTOR position;	///< IuWFNgWB
				DWORD   diffuse; ///< fBt[Y
				DWORD	specular;///< XyL
				float   tu;///< eNX`uW
				float   tv;///< eNX`vW
			};

			/// 3DXvCgp o[ebNXobt@̃tO 
			const DWORD Vertex2FVF = (D3DFVF_DIFFUSE |  D3DFVF_SPECULAR | D3DFVF_XYZ | D3DFVF_TEX1);
	
			/** ConsoleC^[tF[X̎. */
			class ConsoleImpl : public Console  
			{
				// LIFECYCLE //
			public:
				/// RXgN^
				ConsoleImpl();
				/** RXgN^
				* @param hwnd EBhEnh
				* @param bWindow EBhE\tXN[\ */
				ConsoleImpl(const HWND hwnd,const bool bWindow);
				/// fXgN^				
				virtual ~ConsoleImpl();
				// OPERATORS //
				// OPERATIONS //
				virtual void initialize(void);
				/** s.
				 * @param hwnd EBhEnh
				 * @param bWindow true EBhE\ false tXN[\ */
				void initialize(const HWND hwnd,const bool bWindow);

				/** Is.
				 * IɊJȂĂ͂Ȃ̂͂ŊJ */
				void uninitialize(void);

				virtual void clearScreen(COLOR value = 0x00000000);
				virtual void fillScreen(COLOR value = 0x00000000);
				void update(void);
				
				// obNobt@Asciiw肵eNX`[ԍŕ\B
				virtual void print(const int textureNo,const float x,const float y,const float angleRad,const float scale,const COLOR color,
					const char *format,...);
				// XvCg̃[h
				sprite::Sprite* const createSprite(const sprite::Info* const pInfo);

				// ACCESS //

				// INQUIRY //
				virtual const bool isEnabled(void) const {return mbD3DReady;};

			private:
				/** D3DfoCX`FbNAI.
				 * ݂̃n[hEFAD3DfoCX`FbNAConsoleImplKvƂvɑΉAƂ\͂̍̂I܂B*/
				void checkAndSetDevice(const D3DDEVTYPE devtype = D3DDEVTYPE_HAL);

				/** foCX^Cv`FbNAݒ肷 */
				void checkAndSetDeviceType(const D3DDEVTYPE devtype);
	
				/** ݂̃n[hEFÃobNobt@tH[}bg`FbNAݒ肷
				 * VXevobNobt@tH[}bg邩ǂ`FbNAΐݒ肵܂B<br>
				 * Ȃ΁Av̂ɍł߂obNobt@̃tH[}bgI܂ */
				void checkAndSetBackBufferFormat(void);
				/** ݂̃n[hEFÃeNX`tH[}bg`FbNAݒ肷 */
				void checkAndSetTextureFormat(void);
				/** ݂̃n[hEFÃrbg[x𒲂ׂāAݒ肷 */
				void checkAndSetDepthFormat(void);
				
				/// _OXe[gAeNX`Xe[WXe[g̏s
				void initDeviceStates(void);

				/// ʂ̏Er[|[g̐ݒȂǂs 
				void initConsoleViewStyle(void);
				
				/// Cg̏s
				void initLight();

				/// ϊs̏s
				void initMatrix();


				/// Resetɍč쐬ȂĂ͂Ȃs
				void initNotManagedObjects(void);

				/// D3DDeviceŊǗȂIuWFNgJ
				void releaseNotManagedObjects(void);
				
				/// tHgt@Cǂݍ
				void loadFont(void);

				/// t[Jn錾
				void startFrame(void);

				/// t[I錾
				void endFrame(void);

				/// eLXg̕`s
				void textDraw(int textureNo,float x,float y,float angleRad,float scale,COLOR color,char *pBuf);

				/// eLXgL[̓eo͂
				void textOut(void);

				HWND	mhWndMain;///< Windownh
				
				bool					mbD3DReady;///< ׂĂ̏Agp\
				bool					mbWindowed;	///< EBhE[hǂ
				
				LPDIRECT3D9				mpD3D;///< D3D
				D3DDEVTYPE				mD3DDeviceType;///< D3DfoCX^Cv									
				
				LPDIRECT3DDEVICE9		mpD3DDevice;///< D3DDevice
				LPD3DXSPRITE			mpD3DXSprite;///< D3DXSprite
				
				D3DFORMAT				mD3DFormat;///< vC}EobNobt@̃tH[}bg
				D3DFORMAT				mTextureFormat;///< ߃eNX`ptH[}bg
				D3DFORMAT				mDepthFormat;///<@[xobt@ptH[}bg
				D3DPRESENT_PARAMETERS	mD3Dpp;///< D3DPRESENT_PARAMETERS
				
				IDirect3DTexture9* 		mpFontTexture[font::COUNT_MAX];///< tHgeNX`z
				sprite::AbstractSprite* mpSprite[sprite::MAX];///< XvCgeNX`z
				
				///@eLXgێNX
				class TextQueueData{
				public:
					/**@RXgN^ 
					 * @param eNX`ԍ
					 * @param x \xW
					 * @param y \yW
					 * @param angleRad \px(WA)
					 * @param scale gk
					 * @param color \F
					 * @param pBuffer eLXg̃|C^ */
					TextQueueData(const int textureNo,const float x,const float y,const float angleRad,const float scale,const COLOR color,const char *pBuffer = NULL);
					/// fXgN^
					~TextQueueData();
					// ACCESS 
					/** eLXg̃|C^擾.
					 * @return eLXg̐擪AhX */
					char * const buffer(void) { return mpBuf;};
					
					/** tHgeNX`ԍ擾.
					 * @return tHgeNX`ԍ */
					const int textureNo() const { return mTextureNo;};
					
					/** \JnXW擾.
					 * @return \JnXW */
					const float x() const { return mX;};

					/** \JnYW擾.
					 * @return \JnYW */
					const float y() const { return mY;};

					/** \px擾.
					 * @return \JnXW */
					const float angeleRad() const { return mAngleRad;};

					/** gk擾.
					 * @return gk */
					const float scale() const { return mScale;};

					/** \F擾.
					 * @return \F */
					const COLOR color() const { return mColor;};
				private:
					int mTextureNo;///< tHgeNX`ԍ
					float mX;///< \JnXW
					float mY;///< \JnYW
					float mAngleRad;///< \pxiWAj
					float mScale;///< gk
					COLOR mColor;///< \F
					char mpBuf[text::BUFFER_LENGTH];///< \
				};

				/// eLXg\pL[obt@ 
				std::queue<TextQueueData *> mTextQueue;

			}; // ConsoleImpl
		} // namespace console
	} // namespace system
} // namespace sf
}
#endif // !defined(AFX_ConsoleImpl_H__B6F6F87A_C87F_40DA_8F4F_C037111CAC9D__INCLUDED_)
