/**
 * @file Exception.h
 * @brief O̒`s.
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#if !defined(AFX_EXCEPTION_H__F0B6B43A_53BE_4C53_AB43_D64FED220C3B__INCLUDED_)
#define AFX_EXCEPTION_H__F0B6B43A_53BE_4C53_AB43_D64FED220C3B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h"
#include <string>
#include <strstream>
#include "boost/format.hpp"
extern "C" {
namespace sf {
	namespace system {
/// O 
class  Exception {
	public:
	/// G[̎
	enum ERROR_TYPE{
		DEFAULT,///< ftHg
		DEVICE_NOT_FOUND,///< foCXȂ
		BUFFER_IS_FULL,///< obt@[t
		SCENE_IS_EMPTY///< V[͋ł
	};

	/// RXgN^		
	Exception::Exception()
	{
		mErrID = DEFAULT;
	};

	/** RXgN^ 
	 * @param pValue G[
	 * @param fileName t@Cl[
	 * @param line sԍ
	* @param err ERROR_TYPE */
	Exception(const wchar_t * const pValue,const wchar_t * const fileName,const int line,const ERROR_TYPE err = DEFAULT)
		{mErrString = pValue; mFileName = fileName;mLineNumber = line; mErrID = err;};
	/** RXgN^ 
	 * @param value G[
	 * @param fileName t@Cl[
	 * @param line sԍ
	 * @param err ERROR_TYPE */
	Exception(std::wstring & value,const wchar_t * const fileName,const int line,const ERROR_TYPE err = DEFAULT)
		{mErrString = value;mFileName = fileName ; mLineNumber = line; mErrID = err;};
	/// fXgN^
	virtual ~Exception(){};
	
	/** G[QƂ.
	 * @return G[std::string̎QƂŕԂ܂*/
	virtual std::wstring & reason(void)
	{return mErrString;};
	
	/** G[Zbg.
	 * @param value G[(std::string) */
	virtual void reason(const std::wstring& value){mErrString = value;};
	
	/** G[Zbg.
	 * @param value G[(const char *) */
	virtual void reason(const wchar_t * const pValue){mErrString = pValue;};
	
	/** G[Nt@Cl[Zbg 
	 * @param pValue G[Nt@Cl[ */
	virtual void sourceFileName(const wchar_t * const pValue){mFileName = pValue;};
	
	/** G[Nt@Cl[QƂ 
	 * @return G[Nt@Cl[ */
	virtual const std::wstring  sourceFileName(void) const {return mFileName;};

	/** G[NsԍZbg
	 * @param value G[Nsԍ */
	virtual void lineNumber(const int value){mLineNumber = value;};
	
	/** G[NsԍZbg
	 * @param value G[Nsԍ */
	virtual const int lineNumber(void){return mLineNumber;};
	
	/** ERROR_TYPEZbg
	 * @param value ERROR_TYPE(O̎) */
	virtual void errorType(const ERROR_TYPE value){mErrID = value;};
	
	/** ERROR_TYPEQƂ
	 * @return ERROR_TYPE(O̎) */
	virtual const ERROR_TYPE errorType(void) const {return mErrID;};

	/** ftHgG[\bZ[WQƂ
	 * @return G[ */
	virtual const wchar_t * const Exception::getDefaultMessage(void){
		return (boost::wformat(L"%s\n%s:line%d") % reason() % sourceFileName() % lineNumber()).str().c_str();
	}// getDefaultMessage()		

private:
	std::wstring mErrString;///< G[
	std::wstring mFileName;///< G[Nt@C
	std::wstring mDefaultMessage;///< ftHg̃bZ[W
	int mLineNumber;///< sԍ
	ERROR_TYPE mErrID;///< G[ID
};

/// vIȗO
class FatalErrorException : public Exception {
public:
		/** RXgN^ 
		 * @param pValue G[
		 * @param fileName t@Cl[
		 * @param line sԍ
		 * @param err ERROR_TYPE */
		FatalErrorException(const wchar_t * const pValue,const wchar_t * const fileName,const int line,const ERROR_TYPE err = DEFAULT)
			: Exception(pValue,fileName,line)
			{;};
		/** RXgN^ 
		 * @param pValue G[
		 * @param fileName t@Cl[
		 * @param line sԍ
		 * @param err ERROR_TYPE */
		FatalErrorException(std::wstring & value,const wchar_t * const fileName,const int line,const ERROR_TYPE err = DEFAULT)
			: Exception(value,fileName,line)
			{;};
};

///C\ȗO
class RecoverbleErrorException : public Exception {
public:
		/** RXgN^ 
		 * @param pValue G[
		 * @param fileName t@Cl[
		 * @param line sԍ
		 * @param err ERROR_TYPE */
		RecoverbleErrorException(const wchar_t * const pValue,const wchar_t * const fileName,const int line,const ERROR_TYPE err = DEFAULT)
			: Exception(pValue,fileName,line)
			{;};
		/** RXgN^ 
		 * @param pValue G[
		 * @param fileName t@Cl[
		 * @param line sԍ
		 * @param err ERROR_TYPE */
		RecoverbleErrorException(std::wstring & value,const wchar_t * const fileName,const int line,const ERROR_TYPE err = DEFAULT)
			: Exception(value,fileName,line)
			{;};

};
	}// system
}// sf
}
#endif // !defined(AFX_EXCEPTION_H__F0B6B43A_53BE_4C53_AB43_D64FED220C3B__INCLUDED_)
