/**
 * @file
 * @brief 3DXvCg̎s.
 * 
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.*/

#pragma warning( disable : 4786 )	//STĽxO

// [[Nop
#include "sfdebug.h"

#include <string>
#include "stdio.h"
#include "math.h"

#include "system.h"
#include "console.h"

#include "Obj3D.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

using namespace sf::system::console;

Obj3D::Obj3D()
{
	mX = mY = mZ = 0.0f;
	mAngleX = mAngleY = mAngleZ = 0.0f;
	mScalingX = mScalingY = mScalingZ = 1.0f;
	mRotXSin = mRotYSin = mRotZSin = sinf(0.0f); 
	mRotXCos = mRotYCos = mRotZCos = cosf(0.0f); 
	
	mSpaceX = mSpaceY = mSpaceZ = 0.0f;
	
	mbVisibility = false;
	mIndex = 0;
	mpNext = mpPrevious = NULL;
	mDrawMode = DRAW_TRANS;
	mpSprite = NULL;
}

Obj3D::~Obj3D()
{;
}

// XW |||||||||||||||||||||||||||||||||
void Obj3D::x(const float value)
{
	mX = value;
	mSpaceX = value * 2.0f / (float)screen::HEIGHT;
}// x

// XW |||||||||||||||||||||||||||||||||
void Obj3D::y(const float value)
{
	mY = value;
	mSpaceY = - value * 2.0f / (float)screen::HEIGHT;
}// x

// XW |||||||||||||||||||||||||||||||||
void Obj3D::z(const float value)
{
	mSpaceZ = mZ =  value;
	List::deleteObj(this);
	List::insertObj(this);

	//mSpaceZ = value * 2.0f / (float)screen::HEIGHT; 
}// x

// Xpx |||||||||||||||||||||||||||||||||
void Obj3D::angleX(const float value)
{
	mAngleX = value;
	mRotXCos = cosf(value);
	mRotXSin = sinf(value);
}// AngleX()

// Ypx |||||||||||||||||||||||||||||||||
void Obj3D::angleY(const float value)
{
	mAngleY = value;
	mRotYCos = cosf(value);
	mRotYSin = sinf(value);
}// AngleY()

// Xpx |||||||||||||||||||||||||||||||||
void Obj3D::angleZ(const float value)
{
	mAngleZ = value;
	mRotZCos = cosf(value);
	mRotZSin = sinf(value);
}// AngleZ()


