﻿//
// MainPage.xaml.cpp
// Implementation of the MainPage class.
//

#include "pch.h"
#include "GameMain.h"
#include "MainPage.xaml.h"
#include "SoundEditorPage.xaml.h"

using namespace Platform;
using namespace Windows::Foundation;
using namespace Windows::Foundation::Collections;
using namespace Windows::UI::Xaml;
using namespace Windows::UI::Xaml::Controls;
using namespace Windows::UI::Xaml::Controls::Primitives;
using namespace Windows::UI::Xaml::Data;
using namespace Windows::UI::Xaml::Input;
using namespace Windows::UI::Xaml::Media;
using namespace Windows::UI::Xaml::Interop;
using namespace Windows::UI::Xaml::Navigation;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238
namespace ShootingGame
{


MainPage::MainPage(GameMain^ g) : gameMain_(g)
{
  InitializeComponent();
  //std::function<void (Windows::UI::Xaml::Controls::Page^ )> f(std::bind(&MainPage::Subframe,this,std::placeholders::_1));
  gameMain_->SetSubFrameFunc(ref new GameMain::SubFrameFuncDelegate(this,&MainPage::Subframe));
  gameMain_->SetIsBackButtonEnabledDelgate( ref new GameMain::IsBackButtonEnabledDelgate
  (
    [this](bool v)
    {
      backButton->IsEnabled = v;
    }
  )
  );
}

void MainPage::Subframe(Windows::UI::Xaml::Controls::Page^ p)
{
  if(p != nullptr)
  {
   // hiddenFrame_->
     UIElement^ content = p->Content; 
     p->Content = nullptr;
     SubContent->Content = content;
  } else {
     SubContent->Content = nullptr;
  }
}

//UIElement^ MainPage::NavigateSubframe(Windows::UI::Xaml::Interop::TypeName typeName)
//{
//  if(!hiddenFrame_->Navigate(typeName,this))
//  {
//    throw ref new FailureException(ref new String(L"切り替えできませんでした。"));
//  };
//
//  Page^ hiddenPage = safe_cast<Page^>(hiddenFrame_->Content);
//  UIElement^ content = hiddenPage->Content;
//  hiddenPage->Content = nullptr;
//  SubContent->Content =  content;
//  return  content;
//;
//}


/// <summary>
/// Invoked when this page is about to be displayed in a Frame.
/// </summary>
/// <param name="e">Event data that describes how this page was reached.  The Parameter
/// property is typically used to configure the page.</param>
void MainPage::OnNavigatedTo(NavigationEventArgs^ e)
{
  (void) e;	// Unused parameter
}

void MainPage::UpdateProcessTime(float delta)
{
  processTime->Text = ref new String((boost::wformat(L"%1.4f") % delta).str().c_str());
}

void MainPage::UpdateFrameTime(float delta,float max,float min,float avg)
{
  frameTime->Text = ref new String((boost::wformat(L"%1.4f") % delta).str().c_str());
  frameTimeMax->Text = ref new String((boost::wformat(L"%1.4f") % max).str().c_str());
  frameTimeMin->Text = ref new String((boost::wformat(L"%1.4f") % min).str().c_str());
  frameTimeAvg->Text = ref new String((boost::wformat(L"%1.4f") % avg).str().c_str());
}


//void ShootingGame::MainPage::Button_Click_1(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e)
//{
//  //TypeName t = {ref new String(L"ShootingGame.SoundEditorPage"),TypeKind::Custom};
//  // if(!hiddenFrame_->Navigate(t,this))
//  // {
//  //   throw ref new FailureException(ref new String(L"サウンドエディタに切り替えできませんでした。"));
//  // };
//
//  //  Page^ hiddenPage = safe_cast<Page^>(hiddenFrame_->Content);
//  //  UIElement^ content = hiddenPage->Content;
//  //  hiddenPage->Content = nullptr;
//  //  SubContent->Content =  content;
//
//  //Grid^ grid = safe_cast<Grid^>(hiddenPage->FindName(L"LayoutRoot"));
//  //if(grid != nullptr){
//  //// Get each element.
//  //UIElement^ c = safe_cast<UIElement^>(grid->FindName(L"Editor"));
//  //UIElementCollection^ collection = grid->Children;
//  //unsigned int  index;
//  //collection->IndexOf(c, &index);
//  //collection->RemoveAt(index);
//  //SubContent->Content =  c;
//  //}
//
//} 

//void MainPage::GameMain(ShootingGame::GameMain^  p){gameMain_ = p;}
//
//ShootingGame::GameMain^ MainPage::GameMain(){return gameMain_; }
//
void ShootingGame::MainPage::backButton_Click(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e)
{
   gameMain_->GameStateMachine().ProcessEvent(Event::Back());
}
}