/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.main;

import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.Point;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

import jdbcacsess2.main.GuiDivider.DividerGenerator;
import jdbcacsess2.main.GuiFont.FontGenerator;
import jdbcacsess2.main.GuiWindow.WindowGenerator;
import jdbcacsess2.main.icon.IconImage;
import net.java.ao.Entity;
import net.java.ao.Generator;
import net.java.ao.Preload;
import net.java.ao.schema.Default;
import net.java.ao.schema.NotNull;

public class MainView extends JFrame {

	// -------------------------------------------------------------------------
	// -------------------------------------------------------------------------
	// -------------------------------------------------------------------------
	/**
	 * GUIコンポーネント属性を保存する為のActiveObjectsインタフェース
	 * 
	 * @author sima
	 * 
	 */
	@Preload
	public interface ViewMain extends Entity {
		@NotNull
		@Generator(WindowGenerator.class)
		GuiWindow getWindow();
		void setWindow(GuiWindow guiWindow);

		// Tree
		@NotNull
		@Generator(FontGenerator.class)
		GuiFont getTreeFont();
		void setTreeFont(GuiFont guiFont);

		@NotNull
		@Generator(DividerGenerator.class)
		GuiDivider getTreeDivider();
		void setTreeDivider(GuiDivider guiDivider);

		@NotNull
		@Generator(DividerGenerator.class)
		GuiDivider getTreeLastDivider();
		void setTreeLastDivider(GuiDivider guiDivider);

		@NotNull
		@Generator(DividerGenerator.class)
		GuiDivider getDBObjectsDivider();
		void setDBObjectsDivider(GuiDivider guiDivider);

		@NotNull
		@Generator(DividerGenerator.class)
		GuiDivider getDBObjectsLastDivider();
		void setDBObjectsLastDivider(GuiDivider guiDivider);

		// Table
		@NotNull
		@Generator(FontGenerator.class)
		GuiFont getTableFont();
		void setTableFont(GuiFont guiFont);

		@NotNull
		@Generator(DividerGenerator.class)
		GuiDivider getTableDivider();
		void setTableDivider(GuiDivider guiDivider);

		@NotNull
		@Generator(DividerGenerator.class)
		GuiDivider getTableLastDivider();
		void setTableLastDivider(GuiDivider guiDivider);

		// Sql
		@NotNull
		@Generator(FontGenerator.class)
		GuiFont getSqlFont();
		void setSqlFont(GuiFont guiFont);

		// Other
		@NotNull
		@Default("true")
		Boolean getAutoCommit();
		void setAutoCommit(boolean autoCommit);

		@NotNull
		@Default("0")
		Integer getTreeTableColumnWidth0();
		void setTreeTableColumnWidth0(Integer treeTableColumnWidth0);

		@NotNull
		@Default("0")
		Integer getTreeTableColumnWidth1();
		void setTreeTableColumnWidth1(Integer treeTableColumnWidth1);

		@NotNull
		@Default("0")
		Integer getTreeTableColumnWidth2();
		void setTreeTableColumnWidth2(Integer treeTableColumnWidth2);

		@NotNull
		@Default("0")
		Integer getTreeTableColumnWidth3();
		void setTreeTableColumnWidth3(Integer treeTableColumnWidth3);

	}

	public JPanelSession getCurrentJPanelSession() {
		return (JPanelSession) getJTabbedPaneSession().getSelectedComponent();
	}

	public JPanelSql getCurrentJPanelSql() {
		Object o = getCurrentJPanelSession().getJTabbedPaneSql().getSelectedComponent();
		if (o instanceof JPanelSql) {
			return (JPanelSql) o;
		}
		return null;
	}

	/**
	 * Viewのcomponent属性を更新用オブジェクト{ConfigViewMain)に集める。
	 * 
	 * @param c
	 *            component属性を格納する為のConfigViewMain。
	 */
	public void collectViewMain(ViewMain c) {
		Point p = getLocationOnScreen();
		GuiWindow guiWindow = c.getWindow();
		guiWindow.setWidth(getWidth());
		guiWindow.setHeight(getHeight());
		guiWindow.setX(p.x);
		guiWindow.setY(p.y);
		guiWindow.save();

		GuiDivider guiDivider;
		GuiFont guiFont;

		// JPanelSession 関連
		JPanelSession jPanelSession = getCurrentJPanelSession();
		if (jPanelSession == null) {
			return;
		}
		guiFont = c.getTreeFont();
		guiFont.setFont(jPanelSession.getJXTreetableDBObjects().getFont());
		guiFont.save();

		guiDivider = c.getTreeDivider();
		guiDivider.setLocation(jPanelSession.getJSplitPaneTree().getDividerLocation());
		guiDivider.save();

		guiDivider = c.getTreeLastDivider();
		guiDivider.setLocation(jPanelSession.getJSplitPaneTree().getLastDividerLocation());
		guiDivider.save();

		guiDivider = c.getDBObjectsDivider();
		guiDivider.setLocation(jPanelSession.getJSplitPaneDBObjects().getDividerLocation());
		guiDivider.save();

		guiDivider = c.getDBObjectsLastDivider();
		guiDivider.setLocation(jPanelSession.getJSplitPaneDBObjects().getLastDividerLocation());
		guiDivider.save();

		// JPanelSession の TableColumnModel 関連
		TableColumnModel model = getTableColumnModel(jPanelSession);
		if (model != null) {
			if (model.getColumnCount() > 3) {
				c.setTreeTableColumnWidth0(model.getColumn(0).getPreferredWidth());
				c.setTreeTableColumnWidth1(model.getColumn(1).getPreferredWidth());
				c.setTreeTableColumnWidth2(model.getColumn(2).getPreferredWidth());
				c.setTreeTableColumnWidth3(model.getColumn(3).getPreferredWidth());
			}
		}

		// JPanelSql関連
		JPanelSql jPanelSql = getCurrentJPanelSql();
		if (jPanelSql == null) {
			return;
		}

		guiFont = c.getSqlFont();
		guiFont.setFont(jPanelSql.getRSyntaxTextAreaSql().getFont());
		guiFont.save();

		guiFont = c.getTableFont();
		guiFont.setFont(jPanelSql.getJTable().getFont());
		guiFont.save();

		guiDivider = c.getTableDivider();
		guiDivider.setLocation(jPanelSql.getJSplitPaneTable().getDividerLocation());
		guiDivider.save();

		guiDivider = c.getTableLastDivider();
		guiDivider.setLocation(jPanelSql.getJSplitPaneTable().getLastDividerLocation());
		guiDivider.save();
		c.setAutoCommit(jPanelSql.getJCheckBoxAutoCommit().isSelected());

	}

	/**
	 * Viewのcomponent属性を復元する。
	 * 
	 * @param c
	 *            復元する{@link ViewMain}
	 */
	public void setViewMain(ViewMain c) {
		if (c != null) {
			GuiWindow guiWindow = c.getWindow();
			if (guiWindow != null) {
				setSize(guiWindow.getWidth(), guiWindow.getHeight());
				setLocation(guiWindow.getX(), guiWindow.getY());
			}
		}
	}

	/**
	 * Viewのcomponent属性を復元する。
	 * 
	 * @param jPanelSession
	 * 
	 * @param c
	 *            復元する{@link ViewMain}
	 */
	public void setViewMainPanelSesion(JPanelSession jPanelSession, ViewMain c) {
		if (c != null) {
			jPanelSession.getJSplitPaneTree().setDividerLocation(c.getTreeDivider().getLocation());
			jPanelSession.getJSplitPaneTree().setLastDividerLocation(c.getTreeLastDivider().getLocation());
			jPanelSession.getJSplitPaneDBObjects().setDividerLocation(c.getDBObjectsDivider().getLocation());
			jPanelSession.getJSplitPaneDBObjects().setLastDividerLocation(c.getDBObjectsLastDivider().getLocation());
			jPanelSession.getJXTreetableDBObjects().setFont(c.getTreeFont().getFont());
		}
	}

	/**
	 * Viewのcomponent属性を復元する。
	 * 
	 * @param jPanelSql
	 * 
	 * @param c
	 *            復元する{@link ViewMain}
	 */
	public void setViewMainPanelSql(JPanelSql jPanelSql, ViewMain c) {
		if (c != null) {
			jPanelSql.getJSplitPaneTable().setDividerLocation(c.getTableDivider().getLocation());
			jPanelSql.getJSplitPaneTable().setLastDividerLocation(c.getTableLastDivider().getLocation());

			jPanelSql.getJCheckBoxAutoCommit().setSelected(c.getAutoCommit());

			jPanelSql.getRSyntaxTextAreaSql().setFont(c.getSqlFont().getFont());
			jPanelSql.getJTable().setFont(c.getTableFont().getFont());
		}
	}

	/**
	 * Viewのcomponent属性を復元する。
	 * 
	 * @param c
	 *            復元する{@link ViewMain}
	 */
	public void setTreeTableColumnWidth(JPanelSession jPanelSession, ViewMain c) {
		if (c != null) {
			TableColumnModel model = getTableColumnModel(jPanelSession);
			if (model != null) {
				model.getColumn(0).setPreferredWidth(c.getTreeTableColumnWidth0());
				model.getColumn(1).setPreferredWidth(c.getTreeTableColumnWidth1());
				model.getColumn(2).setPreferredWidth(c.getTreeTableColumnWidth2());
				model.getColumn(3).setPreferredWidth(c.getTreeTableColumnWidth3());
			}
		}
	}

	/**
	 * データベースオブジェクトツリーのカラムモデルを取得する
	 * 
	 * @param jPanelSession
	 * 
	 * @return
	 */
	private TableColumnModel getTableColumnModel(JPanelSession jPanelSession) {
		TableColumnModel model = null;
		JTableHeader header = jPanelSession.getJXTreetableDBObjects().getTableHeader();
		if (header != null) {
			model = header.getColumnModel();
		}
		return model;
	}

	/**
	 * tabnedPaneのtabComponent上のマウス位置を把握する
	 */
	public TabbedPaneMousePointer tabbedPaneMousePointer;

	// -------------------------------------------------------------------------
	// -------------------------------------------------------------------------
	// -------------------------------------------------------------------------

	private static final long serialVersionUID = 1453095034661464158L;
	private JPanel jContentPane = null;
	private JTabbedPane jTabbedPaneSession = null;
	private JMenuBar jJMenuBar = null;
	private JMenu fileMenu = null;
	private JMenuItem saveMenuItem = null;
	private JMenuItem exitMenuItem = null;
	private JMenu editMenu = null;
	private JMenuItem cutMenuItem = null;
	private JMenuItem copyMenuItem = null;
	private JMenuItem pasteMenuItem = null;
	private JMenu helpMenu = null;
	private JMenuItem aboutMenuItem = null;
	private JPopupMenu jPopupTabbedSession = null;
	private JMenuItem jMenuTabbedSessionNew = null;
	private JMenuItem jMenuTabbedSessionClose = null;
	private JMenuItem jMenuTabbedSessionReNew = null;

	public MainView() {
		initialize();
	}

	private void initialize() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(1000, 700);
		setContentPane(getJContentPane());
		setJMenuBar(getJJMenuBar());
		setTitle("jdbcacsess2");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJTabbedPaneSession(), java.awt.BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jTabbedPaneSession
	 * 
	 * @return javax.swing.JTabbedPane
	 */
	JTabbedPane getJTabbedPaneSession() {
		if (jTabbedPaneSession == null) {
			jTabbedPaneSession = new JTabbedPane();
			jTabbedPaneSession.setComponentPopupMenu(getJPopupTabbedSession());
			tabbedPaneMousePointer = new TabbedPaneMousePointer(jTabbedPaneSession);
		}
		return jTabbedPaneSession;
	}

	/**
	 * This method initializes jJMenuBar
	 * 
	 * @return javax.swing.JMenuBar
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getFileMenu());
			jJMenuBar.add(getEditMenu());
			jJMenuBar.add(getHelpMenu());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes fileMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getFileMenu() {
		if (fileMenu == null) {
			fileMenu = new JMenu();
			fileMenu.setText("ファイル");
			fileMenu.add(getSaveMenuItem());
			fileMenu.add(getExitMenuItem());
		}
		return fileMenu;
	}

	/**
	 * This method initializes saveMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getSaveMenuItem() {
		if (saveMenuItem == null) {
			saveMenuItem = new JMenuItem();
			saveMenuItem.setText("Save");
			saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK, true));
		}
		return saveMenuItem;
	}

	/**
	 * This method initializes exitMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	JMenuItem getExitMenuItem() {
		if (exitMenuItem == null) {
			exitMenuItem = new JMenuItem();
			exitMenuItem.setText("Exit");
		}
		return exitMenuItem;
	}

	/**
	 * This method initializes editMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getEditMenu() {
		if (editMenu == null) {
			editMenu = new JMenu();
			editMenu.setText("Edit");
			editMenu.add(getCutMenuItem());
			editMenu.add(getCopyMenuItem());
			editMenu.add(getPasteMenuItem());
		}
		return editMenu;
	}

	/**
	 * This method initializes cutMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getCutMenuItem() {
		if (cutMenuItem == null) {
			cutMenuItem = new JMenuItem();
			cutMenuItem.setText("Cut");
			cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, Event.CTRL_MASK, true));
		}
		return cutMenuItem;
	}

	/**
	 * This method initializes copyMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getCopyMenuItem() {
		if (copyMenuItem == null) {
			copyMenuItem = new JMenuItem();
			copyMenuItem.setText("Copy");
			copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK, true));
		}
		return copyMenuItem;
	}

	/**
	 * This method initializes pasteMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getPasteMenuItem() {
		if (pasteMenuItem == null) {
			pasteMenuItem = new JMenuItem();
			pasteMenuItem.setText("Paste");
			pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, Event.CTRL_MASK, true));
		}
		return pasteMenuItem;
	}

	/**
	 * This method initializes helpMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getHelpMenu() {
		if (helpMenu == null) {
			helpMenu = new JMenu();
			helpMenu.setText("Help");
			helpMenu.add(getAboutMenuItem());
		}
		return helpMenu;
	}

	/**
	 * This method initializes aboutMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getAboutMenuItem() {
		if (aboutMenuItem == null) {
			aboutMenuItem = new JMenuItem();
			aboutMenuItem.setText("About");
			aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					Jdbcacsess2.logger.info("actionPerformed()");
					// TODO
					// Auto-generated
					// Event stub
					// actionPerformed()
				}
			});
		}
		return aboutMenuItem;
	}

	/**
	 * This method initializes jPopupTabbedSession
	 * 
	 * @return javax.swing.JPopupMenu
	 */
	private JPopupMenu getJPopupTabbedSession() {
		if (jPopupTabbedSession == null) {
			jPopupTabbedSession = new JPopupMenu();
			jPopupTabbedSession.add(getJMenuTabbedSessionNew());
			jPopupTabbedSession.add(getJMenuTabbedSessionReNew());
			jPopupTabbedSession.add(getJMenuTabbedSessionClose());
		}
		return jPopupTabbedSession;
	}

	/**
	 * This method initializes jMenuTabbedSessionNew
	 * 
	 * @return javax.swing.JMenuItem
	 */
	JMenuItem getJMenuTabbedSessionNew() {
		if (jMenuTabbedSessionNew == null) {
			jMenuTabbedSessionNew = new JMenuItem(IconImage.SERVER_ADD.getValue());
			jMenuTabbedSessionNew.setText("New connect");
		}
		return jMenuTabbedSessionNew;
	}

	/**
	 * This method initializes jMenuTabbedSessionClose
	 * 
	 * @return javax.swing.JMenuItem
	 */
	JMenuItem getJMenuTabbedSessionClose() {
		if (jMenuTabbedSessionClose == null) {
			jMenuTabbedSessionClose = new JMenuItem(IconImage.SERVER_DELETE.getValue());
			jMenuTabbedSessionClose.setText("Close connect");
		}
		return jMenuTabbedSessionClose;
	}

	/**
	 * This method initializes jMenuTabbedSessionReNew
	 * 
	 * @return javax.swing.JMenuItem
	 */
	JMenuItem getJMenuTabbedSessionReNew() {
		if (jMenuTabbedSessionReNew == null) {
			jMenuTabbedSessionReNew = new JMenuItem(IconImage.SERVER_GO.getValue());
			jMenuTabbedSessionReNew.setText("Re Connect");
		}
		return jMenuTabbedSessionReNew;
	}

}
