/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.main.icon;

import javax.swing.Icon;
import javax.swing.ImageIcon;

public enum IconImage {
	CONNECT("connect.png"), DISCONNECT("disconnect.png"), EXECUTE("execute.png"), STOP("list-remove.png"), GO_DOWN(
			"go-down.png"), ROLLBACK("edit-undo.png"), COMMIT("database_save.png"), REFRESH("database_refresh.png")
			, SERVER_ADD(
					"server_add.png"), SERVER_DELETE("server_delete.png"), SERVER_GO("server_go.png")
, TAB_ADD("tab_add.png"), TAB_DELETE(
							"tab_delete.png")
							;

	private final Icon Icon;

	private IconImage(String imageFile) {
		Icon = new ImageIcon(IconImage.class.getResource(imageFile));
	}

	private IconImage() {
		Icon = new ImageIcon();
	}

	public Icon getValue() {
		return Icon;
	}
}
