/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;

public class CodeTemplateManager {
    private int maxTemplateIDLength;
    private List templates;
    private KeyStroke insertTrigger;
    private String insertTriggerString;
    private Segment s;
    private TemplateComparator comparator;
    private File directory;
    private static final int mask = 3;
    static final KeyStroke TEMPLATE_KEYSTROKE = KeyStroke.getKeyStroke(32, 3);

    public CodeTemplateManager() {
        this.setInsertTrigger(TEMPLATE_KEYSTROKE);
        this.s = new Segment();
        this.comparator = new TemplateComparator();
        this.templates = new ArrayList();
    }

    public synchronized void addTemplate(CodeTemplate codeTemplate) {
        if (codeTemplate == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        this.templates.add(codeTemplate);
        this.sortTemplates();
    }

    public KeyStroke getInsertTrigger() {
        return this.insertTrigger;
    }

    public String getInsertTriggerString() {
        return this.insertTriggerString;
    }

    public synchronized CodeTemplate getTemplate(RSyntaxTextArea rSyntaxTextArea) {
        int n = rSyntaxTextArea.getCaretPosition();
        int n2 = Math.min(n, this.maxTemplateIDLength);
        try {
            Document document = rSyntaxTextArea.getDocument();
            document.getText(n - n2, n2, this.s);
            int n3 = Collections.binarySearch(this.templates, this.s, this.comparator);
            return n3 >= 0 ? (CodeTemplate)this.templates.get(n3) : null;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            throw new InternalError("Error in CodeTemplateManager");
        }
    }

    public synchronized int getTemplateCount() {
        return this.templates.size();
    }

    public synchronized CodeTemplate[] getTemplates() {
        CodeTemplate[] codeTemplateArray = new CodeTemplate[this.templates.size()];
        return this.templates.toArray(codeTemplateArray);
    }

    public static final boolean isValidChar(char c) {
        return RSyntaxUtilities.isLetterOrDigit(c) || c == '_';
    }

    public synchronized boolean removeTemplate(CodeTemplate codeTemplate) {
        if (codeTemplate == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        return this.templates.remove(codeTemplate);
    }

    public synchronized CodeTemplate removeTemplate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        Iterator iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
            if (!string.equals(codeTemplate.getID())) continue;
            iterator.remove();
            return codeTemplate;
        }
        return null;
    }

    public synchronized void replaceTemplates(CodeTemplate[] codeTemplateArray) {
        this.templates.clear();
        if (codeTemplateArray != null) {
            for (int i = 0; i < codeTemplateArray.length; ++i) {
                this.templates.add(codeTemplateArray[i]);
            }
        }
        this.sortTemplates();
    }

    public synchronized boolean saveTemplates() {
        boolean bl;
        if (this.templates == null) {
            return true;
        }
        if (this.directory == null || !this.directory.isDirectory()) {
            return false;
        }
        File[] fileArray = this.directory.listFiles(new XMLFileFilter());
        if (fileArray == null) {
            return false;
        }
        boolean bl2 = fileArray.length;
        for (bl = false; bl < bl2; bl += 1) {
            fileArray[bl].delete();
        }
        bl = true;
        Iterator iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
            File file = new File(this.directory, codeTemplate.getID() + ".xml");
            try {
                XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));
                xMLEncoder.writeObject(codeTemplate);
                xMLEncoder.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }

    public void setInsertTrigger(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.insertTrigger = keyStroke;
            this.insertTriggerString = Character.toString(keyStroke.getKeyChar());
        }
    }

    public synchronized int setTemplateDirectory(File file) {
        if (file != null && file.isDirectory()) {
            this.directory = file;
            File[] fileArray = file.listFiles(new XMLFileFilter());
            int n = fileArray == null ? 0 : fileArray.length;
            int n2 = this.templates.size();
            ArrayList<Object> arrayList = new ArrayList<Object>(n2 + n);
            arrayList.addAll(this.templates);
            for (int i = 0; i < n; ++i) {
                try {
                    XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(fileArray[i])));
                    Object object = xMLDecoder.readObject();
                    if (!(object instanceof CodeTemplate)) {
                        throw new IOException("Not a CodeTemplate: " + fileArray[i].getAbsolutePath());
                    }
                    arrayList.add(object);
                    xMLDecoder.close();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.templates = arrayList;
            this.sortTemplates();
            return this.getTemplateCount();
        }
        return -1;
    }

    private synchronized void sortTemplates() {
        this.maxTemplateIDLength = 0;
        Iterator iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
            if (codeTemplate == null || codeTemplate.getID() == null) {
                iterator.remove();
                continue;
            }
            this.maxTemplateIDLength = Math.max(this.maxTemplateIDLength, codeTemplate.getID().length());
        }
        Collections.sort(this.templates);
    }

    private static class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".xml");
        }
    }

    private static class TemplateComparator
    implements Comparator,
    Serializable {
        private TemplateComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            CodeTemplate codeTemplate = (CodeTemplate)object;
            char[] cArray = codeTemplate.getID().toCharArray();
            int n2 = 0;
            int n3 = cArray.length;
            Segment segment = (Segment)object2;
            char[] cArray2 = segment.array;
            int n4 = segment.count;
            for (n = segment.offset + n4 - 1; n >= segment.offset && CodeTemplateManager.isValidChar(cArray2[n]); --n) {
            }
            int n5 = ++n - segment.offset;
            int n6 = Math.min(n3, n4 -= n5);
            while (n6-- != 0) {
                char c;
                char c2;
                if ((c2 = cArray[n2++]) == (c = cArray2[n++])) continue;
                return c2 - c;
            }
            return n3 - n4;
        }
    }
}

