package jp.ito.camera;

import java.io.File;
import java.io.FileOutputStream;

import android.content.ContentValues;
import android.hardware.Camera;
import android.hardware.Camera.PictureCallback;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore.Images;
import android.util.Log;

public class CameraService {
	private static final String TAG = CameraService.class.getSimpleName();
	private	volatile Camera		_Camera;
	private	volatile boolean	_ready;
	private	volatile long		_nShotNo;
	private MainService _mainService = null;

	public CameraService(MainService mainService){
		Log.d(TAG, "CameraService()");
    	_mainService = mainService;

		try {
			_Camera = Camera.open();
		} catch (Exception e) {
			e.printStackTrace();
			Log.e(TAG, "Camera.open() : Failer." + e.getMessage());
			_mainService.toast("Camera.open():" + e.getMessage());
		}
		_ready = true;
		_nShotNo = 0;
	}

	public void OnSaveState(Bundle outState){
		Log.d(TAG, "OnSaveState()");

		if(outState != null){
			outState.putLong("_nShotNo",_nShotNo);
		}
	}

	public void OnLoadState(Bundle savedInstanceState){
		Log.d(TAG, "OnLoadState()");

		if(savedInstanceState != null){
			_nShotNo = savedInstanceState.getLong("_nShotNo");
		}
	}

	private ShutterCallback		_pfnShutterCallback = new ShutterCallback();
	private final class ShutterCallback implements android.hardware.Camera.ShutterCallback{
		public void onShutter(){
			Log.d(TAG, "onShutter()");
		}
	};

	private RawPictureCallback	_pfnRawPictureCallback = new RawPictureCallback();
	private final class RawPictureCallback implements PictureCallback{
		public void onPictureTaken(byte [] rawData, android.hardware.Camera camera)
		{
			Log.d(TAG, "onRawPictureTaken()");
		};
	}

	private final class JpgPictureCallback implements PictureCallback{
		public void onPictureTaken(byte [] data, android.hardware.Camera camera){
			Log.d(TAG, "onJpgPictureTaken()");

			String	strFolder;
			String	strFile;

			strFolder = Environment.getExternalStorageDirectory()+"/DCIM/Camera/";
			strFile = strFolder + "test" + _nShotNo + ".jpg";
			try{
				FileOutputStream	cFile = new FileOutputStream(strFile);
				cFile.write(data);
				cFile.close();

				long	nDate;
				ContentValues values = new ContentValues();

				nDate = System.currentTimeMillis();
				values.put(Images.Media.MIME_TYPE,"image/jpeg");			//
				values.put(Images.Media.DATA,strFile);						//
				values.put(Images.Media.SIZE,new File(strFile).length()); 	//
				values.put(Images.Media.DATE_ADDED,nDate);
				values.put(Images.Media.DATE_TAKEN,nDate);
				values.put(Images.Media.DATE_MODIFIED,nDate);
			} catch(Exception e){
				Log.e(TAG, "onJpgPictureTaken() : Fail to save image file.");
			}
			_nShotNo++;

			try {
				camera.startPreview();
			} catch(Exception e){
				Log.e(TAG, "onJpgPictureTaken() : Fail to startPreview() " + e);
			}
			_mainService.sendPhoto(strFile);
		};
	};
	public void takePicture(){
		if (_ready){
			try {
				_ready = false;
				_Camera.takePicture(_pfnShutterCallback, _pfnRawPictureCallback,new JpgPictureCallback());
			} finally {
				_ready = true;
			}
		}
	}
	public Camera getCamera(){
		return _Camera;
	}
}
